/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.tracer.binding.spring.context;

import java.util.Map;
import java.util.concurrent.Executor;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInvocation;
import org.miaixz.bus.tracer.Backend;
import org.springframework.aop.framework.ReflectiveMethodInvocation;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.scheduling.annotation.AnnotationAsyncExecutionInterceptor;
import org.springframework.scheduling.annotation.AsyncAnnotationAdvisor;
import org.springframework.scheduling.annotation.AsyncAnnotationBeanPostProcessor;

public class PreTpicAsyncBeanPostProcessor
extends AsyncAnnotationBeanPostProcessor {
    public PreTpicAsyncBeanPostProcessor(Executor executor, Backend backend) {
        this.advisor = new TpicPreAdvisor(executor, backend);
        this.setBeforeExistingAdvisors(true);
    }

    boolean isBeforeExistingAdvisors() {
        return this.beforeExistingAdvisors;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
    }

    class TpicPreAdvisor
    extends AsyncAnnotationAdvisor {
        private final Backend backend;
        private final Executor executor;

        TpicPreAdvisor(Executor executor, Backend backend) {
            this.executor = executor;
            this.backend = backend;
            PreTpicAsyncBeanPostProcessor.this.setExecutor(executor);
        }

        public Advice getAdvice() {
            return new DelegateTpicToAsyncInterceptor(this.executor, this.backend);
        }
    }

    static class DelegateTpicToAsyncInterceptor
    extends AnnotationAsyncExecutionInterceptor {
        private final Backend backend;

        DelegateTpicToAsyncInterceptor(Executor defaultExecutor, Backend backend) {
            super(defaultExecutor);
            this.backend = backend;
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            if (invocation instanceof ReflectiveMethodInvocation) {
                Map<String, String> tpic = this.backend.copyToMap();
                ((ReflectiveMethodInvocation)invocation).setUserAttribute("TPIC", tpic);
            }
            return invocation.proceed();
        }

        public int getOrder() {
            return Integer.MIN_VALUE;
        }
    }
}

