/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.tracer.binding.spring.http;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.miaixz.bus.tracer.Backend;
import org.miaixz.bus.tracer.Tracer;
import org.miaixz.bus.tracer.config.TraceFilterConfig;
import org.miaixz.bus.tracer.transport.HttpHeaderTransport;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public final class TraceClientHttpRequestInterceptor
implements ClientHttpRequestInterceptor {
    private final Backend backend;
    private final HttpHeaderTransport transportSerialization;
    private final String profile;

    public TraceClientHttpRequestInterceptor() {
        this(Tracer.getBackend(), new HttpHeaderTransport(), "default");
    }

    public TraceClientHttpRequestInterceptor(String profile) {
        this(Tracer.getBackend(), new HttpHeaderTransport(), profile);
    }

    public TraceClientHttpRequestInterceptor(Backend backend, HttpHeaderTransport transportSerialization, String profile) {
        this.backend = backend;
        this.transportSerialization = transportSerialization;
        this.profile = profile;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        this.preRequest(request);
        ClientHttpResponse response = execution.execute(request, body);
        this.postResponse(response);
        return response;
    }

    private void preRequest(HttpRequest request) {
        TraceFilterConfig filterConfiguration = this.backend.getConfiguration(this.profile);
        if (!this.backend.isEmpty() && filterConfiguration.shouldProcessContext(TraceFilterConfig.Channel.OutgoingRequest)) {
            Map<String, String> filteredParams = filterConfiguration.filterDeniedParams(this.backend.copyToMap(), TraceFilterConfig.Channel.OutgoingRequest);
            request.getHeaders().add("TPIC", this.transportSerialization.render(filteredParams));
        }
    }

    private void postResponse(ClientHttpResponse response) {
        TraceFilterConfig filterConfiguration;
        List headers = response.getHeaders().get((Object)"TPIC");
        if (null != headers && (filterConfiguration = this.backend.getConfiguration(this.profile)).shouldProcessContext(TraceFilterConfig.Channel.IncomingResponse)) {
            this.backend.putAll(filterConfiguration.filterDeniedParams(this.transportSerialization.parse(headers), TraceFilterConfig.Channel.IncomingResponse));
        }
    }
}

