/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.tracer.binding.spring.web;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import org.miaixz.bus.tracer.Backend;
import org.miaixz.bus.tracer.Builder;
import org.miaixz.bus.tracer.Tracer;
import org.miaixz.bus.tracer.config.TraceFilterConfig;
import org.miaixz.bus.tracer.transport.HttpHeaderTransport;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

@Component
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public final class TraceInterceptor
implements HandlerInterceptor {
    private final Backend backend;
    private final HttpHeaderTransport httpHeaderSerialization;
    private String outgoingHeaderName = "TPIC";
    private String incomingHeaderName = "TPIC";
    private String profileName;

    public TraceInterceptor() {
        this(Tracer.getBackend());
    }

    public TraceInterceptor(Backend backend) {
        this.backend = backend;
        this.httpHeaderSerialization = new HttpHeaderTransport();
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object o) {
        Enumeration headers;
        TraceFilterConfig configuration = this.backend.getConfiguration(this.profileName);
        if (configuration.shouldProcessContext(TraceFilterConfig.Channel.IncomingRequest) && null != (headers = request.getHeaders(this.incomingHeaderName)) && headers.hasMoreElements()) {
            Map<String, String> parsedContext = this.httpHeaderSerialization.parse(Collections.list(headers));
            this.backend.putAll(configuration.filterDeniedParams(parsedContext, TraceFilterConfig.Channel.IncomingResponse));
        }
        Builder.generateInvocationIdIfNecessary(this.backend);
        HttpSession session = request.getSession(false);
        if (null != session) {
            Builder.generateSessionIdIfNecessary(this.backend, session.getId());
        }
        this.writeHeaderIfUncommitted(response);
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object o, ModelAndView modelAndView) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object o, Exception e) {
        try {
            this.writeHeaderIfUncommitted(response);
        }
        finally {
            this.backend.clear();
        }
    }

    private void writeHeaderIfUncommitted(HttpServletResponse response) {
        TraceFilterConfig configuration;
        if (!response.isCommitted() && !this.backend.isEmpty() && (configuration = this.backend.getConfiguration(this.profileName)).shouldProcessContext(TraceFilterConfig.Channel.OutgoingResponse)) {
            Map<String, String> filteredContext = configuration.filterDeniedParams(this.backend.copyToMap(), TraceFilterConfig.Channel.OutgoingResponse);
            response.setHeader(this.outgoingHeaderName, this.httpHeaderSerialization.render(filteredContext));
        }
    }

    public void setOutgoingHeaderName(String outgoingHeaderName) {
        this.outgoingHeaderName = outgoingHeaderName;
    }

    public void setIncomingHeaderName(String incomingHeaderName) {
        this.incomingHeaderName = incomingHeaderName;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }
}

