/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.tracer.binding.spring.web;

import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.miaixz.bus.tracer.binding.spring.web.TraceInterceptor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.Order;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@Order
@ControllerAdvice
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class TraceResponseBodyAdvice
implements ResponseBodyAdvice<Object> {
    @Resource
    private TraceInterceptor interceptor;

    public TraceResponseBodyAdvice() {
    }

    TraceResponseBodyAdvice(TraceInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return true;
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest springHttpRequest, ServerHttpResponse springHttpResponse) {
        if (springHttpRequest instanceof ServletServerHttpRequest && springHttpResponse instanceof ServletServerHttpResponse) {
            HttpServletRequest request = ((ServletServerHttpRequest)springHttpRequest).getServletRequest();
            HttpServletResponse response = ((ServletServerHttpResponse)springHttpResponse).getServletResponse();
            try {
                this.interceptor.afterCompletion(request, response, null, null);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return body;
    }
}

