/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.vortex;

import lombok.Generated;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.vortex.Context;
import org.miaixz.bus.vortex.Provider;
import org.miaixz.bus.vortex.provider.JsonProvider;
import org.miaixz.bus.vortex.provider.XmlProvider;
import org.springframework.http.MediaType;
import org.springframework.web.server.ServerWebExchange;

public enum Format {
    XML(new XmlProvider(), MediaType.parseMediaType((String)"application/xml;charset=UTF-8")),
    JSON(new JsonProvider(), MediaType.APPLICATION_JSON),
    PDF,
    BINARY;

    private Provider provider;
    private MediaType mediaType;

    public static void error(ServerWebExchange exchange, String operation, String message) {
        Logger.error((String)"{}[{}] [{}] [{}] - {}", (Object[])new Object[]{Format.getTraceId(exchange), Format.getMethod(exchange), Format.getPath(exchange), operation, message});
    }

    public static void warn(ServerWebExchange exchange, String operation, String message) {
        Logger.warn((String)"{}[{}] [{}] [{}] - {}", (Object[])new Object[]{Format.getTraceId(exchange), Format.getMethod(exchange), Format.getPath(exchange), operation, message});
    }

    public static void info(ServerWebExchange exchange, String operation, String message) {
        Logger.info((String)"{}[{}] [{}] [{}] - {}", (Object[])new Object[]{Format.getTraceId(exchange), Format.getMethod(exchange), Format.getPath(exchange), operation, message});
    }

    public static void debug(ServerWebExchange exchange, String operation, String message) {
        Logger.debug((String)"{}[{}] [{}] [{}] - {}", (Object[])new Object[]{Format.getTraceId(exchange), Format.getMethod(exchange), Format.getPath(exchange), operation, message});
    }

    public static void trace(ServerWebExchange exchange, String operation, String message) {
        Logger.trace((String)"{}[{}] [{}] [{}] - {}", (Object[])new Object[]{Format.getTraceId(exchange), Format.getMethod(exchange), Format.getPath(exchange), operation, message});
    }

    public static void requestStart(ServerWebExchange exchange) {
        if (exchange == null) {
            return;
        }
        Context context = Context.get(exchange);
        if (context == null) {
            return;
        }
        String path = Format.getPath(exchange);
        String method = Format.getMethod(exchange);
        String queryString = exchange.getRequest().getQueryParams().toSingleValueMap().toString();
        Format.info(exchange, "REQUEST_START", String.format("Method: %s, Path: %s, Query: %s", method, path, queryString));
    }

    public static void requestEnd(ServerWebExchange exchange, int statusCode) {
        if (exchange == null) {
            return;
        }
        Context context = Context.get(exchange);
        if (context == null) {
            return;
        }
        long executionTime = System.currentTimeMillis() - context.getStartTime();
        String path = Format.getPath(exchange);
        String method = Format.getMethod(exchange);
        Format.info(exchange, "REQUEST_END", String.format("Method: %s, Path: %s, Status: %d, ExecutionTime: %dms", method, path, statusCode, executionTime));
    }

    private static String getTraceId(ServerWebExchange exchange) {
        if (exchange == null) {
            return "N/A";
        }
        Context context = Context.get(exchange);
        if (context == null) {
            return "N/A";
        }
        String traceId = exchange.getLogPrefix();
        if (traceId == null) {
            return "N/A";
        }
        if (traceId.startsWith("[") && traceId.endsWith("]")) {
            return traceId.substring(1, traceId.length() - 1).trim();
        }
        return traceId;
    }

    private static String getMethod(ServerWebExchange exchange) {
        if (exchange == null || exchange.getRequest().getMethod() == null) {
            return "N/A";
        }
        return exchange.getRequest().getMethod().name();
    }

    private static String getPath(ServerWebExchange exchange) {
        if (exchange == null) {
            return "N/A";
        }
        return exchange.getRequest().getPath().value();
    }

    @Generated
    public Provider getProvider() {
        return this.provider;
    }

    @Generated
    public MediaType getMediaType() {
        return this.mediaType;
    }

    @Generated
    private Format() {
    }

    @Generated
    private Format(Provider provider, MediaType mediaType) {
        this.provider = provider;
        this.mediaType = mediaType;
    }
}

