/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.vortex.filter;

import java.util.Map;
import org.miaixz.bus.core.lang.exception.BusinessException;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.vortex.Assets;
import org.miaixz.bus.vortex.Context;
import org.miaixz.bus.vortex.Filter;
import org.miaixz.bus.vortex.Format;
import org.miaixz.bus.vortex.magic.ErrorCode;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public abstract class AbstractFilter
implements Filter {
    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        Format.info(exchange, "FILTER_ENTER", "Entering filter: " + this.getClass().getSimpleName());
        try {
            return this.doFilter(exchange, chain, this.getContext(exchange)).doOnTerminate(() -> Format.debug(exchange, "FILTER_EXIT", "Exiting filter: " + this.getClass().getSimpleName())).doOnError(e -> Format.error(exchange, "FILTER_ERROR", "Error in " + this.getClass().getSimpleName() + ": " + e.getMessage()));
        }
        catch (Exception e2) {
            Format.error(exchange, "FILTER_FAILED", "Failed in " + this.getClass().getSimpleName() + ": " + e2.getMessage());
            return Mono.error((Throwable)(e2 instanceof BusinessException ? e2 : new BusinessException(ErrorCode._FAILURE)));
        }
    }

    protected abstract Mono<Void> doFilter(ServerWebExchange var1, WebFilterChain var2, Context var3);

    protected Context getContext(ServerWebExchange exchange) {
        Context context = Context.get(exchange);
        if (context == null) {
            throw new BusinessException(ErrorCode._100805);
        }
        return context;
    }

    protected Assets getAssets(Context context) {
        if (context == null) {
            throw new BusinessException(ErrorCode._100805);
        }
        return context.getAssets();
    }

    protected Map<String, String> getRequestMap(Context context) {
        if (context == null) {
            throw new BusinessException(ErrorCode._100805);
        }
        return context.getRequestMap();
    }

    protected ServerWebExchange setContentType(ServerWebExchange exchange) {
        ServerHttpRequest request = exchange.getRequest();
        MediaType mediaType = request.getHeaders().getContentType();
        if (null == mediaType) {
            mediaType = MediaType.APPLICATION_FORM_URLENCODED;
            final HttpHeaders headers = new HttpHeaders();
            headers.putAll((Map)exchange.getRequest().getHeaders());
            headers.setContentType(mediaType);
            ServerHttpRequestDecorator requestDecorator = new ServerHttpRequestDecorator(this, request){

                public HttpHeaders getHeaders() {
                    return headers;
                }
            };
            return exchange.mutate().request((ServerHttpRequest)requestDecorator).build();
        }
        return exchange;
    }

    protected void checkParams(ServerWebExchange exchange) {
        Context context = this.getContext(exchange);
        Map<String, String> params = this.getRequestMap(context);
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (!"undefined".equals(entry.getKey().toLowerCase()) && !"undefined".equals(entry.getValue().toLowerCase())) continue;
            throw new BusinessException(ErrorCode._100101);
        }
        if (StringKit.isBlank((CharSequence)params.get("method"))) {
            throw new BusinessException(ErrorCode._100108);
        }
        if (StringKit.isBlank((CharSequence)params.get("v"))) {
            throw new BusinessException(ErrorCode._100107);
        }
        if (StringKit.isBlank((CharSequence)params.get("format"))) {
            throw new BusinessException(ErrorCode._100111);
        }
        if (StringKit.isNotBlank((CharSequence)params.get("sign"))) {
            context.setNeedDecrypt(true);
        }
    }
}

