/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.vortex.filter;

import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.miaixz.bus.core.basic.entity.Authorize;
import org.miaixz.bus.core.bean.copier.CopyOptions;
import org.miaixz.bus.core.lang.exception.BusinessException;
import org.miaixz.bus.core.xyz.BeanKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.vortex.Assets;
import org.miaixz.bus.vortex.Channel;
import org.miaixz.bus.vortex.Context;
import org.miaixz.bus.vortex.Format;
import org.miaixz.bus.vortex.filter.AbstractFilter;
import org.miaixz.bus.vortex.magic.Delegate;
import org.miaixz.bus.vortex.magic.ErrorCode;
import org.miaixz.bus.vortex.magic.Token;
import org.miaixz.bus.vortex.provider.AuthorizeProvider;
import org.miaixz.bus.vortex.registry.AssetsRegistry;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

@Order(value=-2147483646)
public class AuthorizeFilter
extends AbstractFilter {
    private final AuthorizeProvider provider;
    private final AssetsRegistry registry;

    public AuthorizeFilter(AuthorizeProvider provider, AssetsRegistry registry) {
        this.provider = provider;
        this.registry = registry;
    }

    @Override
    protected Mono<Void> doFilter(ServerWebExchange exchange, WebFilterChain chain, Context context) {
        Map<String, String> params = this.getRequestMap(context);
        context.setFormat(Format.valueOf(StringKit.toUpperCase((CharSequence)params.get("format"))));
        context.setChannel(Channel.get(params.get("x_remote_channel")));
        context.setToken(exchange.getRequest().getHeaders().getFirst("X-Access-Token"));
        String method = params.get("method");
        String version = params.get("v");
        Assets assets = this.registry.get(method, version);
        if (null == assets) {
            Format.warn(exchange, "AUTH_ASSETS_NOT_FOUND", "Assets not found for method: " + method + ", version: " + version);
            return Mono.error((Throwable)new BusinessException(ErrorCode._100800));
        }
        this.checkMethod(exchange, assets);
        this.checkToken(exchange, context, assets, params);
        this.checkAppId(exchange, assets, params);
        this.fillXParam(exchange, params);
        this.cleanParam(params);
        context.setAssets(assets);
        Format.info(exchange, "AUTH_VALIDATED", "Method: " + method + ", Version: " + version);
        return chain.filter(exchange);
    }

    protected void checkMethod(ServerWebExchange exchange, Assets assets) {
        ServerHttpRequest request = exchange.getRequest();
        if (!Objects.equals(request.getMethod(), assets.getHttpMethod())) {
            String error = "HTTP method mismatch, expected: " + String.valueOf(assets.getHttpMethod()) + ", actual: " + String.valueOf(request.getMethod());
            Format.warn(exchange, "AUTH_METHOD_MISMATCH", error);
            if (Objects.equals(assets.getHttpMethod(), HttpMethod.GET)) {
                throw new BusinessException(ErrorCode._100200);
            }
            if (Objects.equals(assets.getHttpMethod(), HttpMethod.POST)) {
                throw new BusinessException(ErrorCode._100201);
            }
            throw new BusinessException(ErrorCode._100803);
        }
    }

    protected void checkToken(ServerWebExchange exchange, Context context, Assets assets, Map<String, String> params) {
        if (assets.isToken()) {
            if (StringKit.isBlank((CharSequence)context.getToken())) {
                Format.warn(exchange, "AUTH_TOKEN_MISSING", "Access token is missing");
                throw new BusinessException(ErrorCode._100106);
            }
            Token access = new Token(context.getToken(), context.getChannel().getType(), assets);
            Delegate delegate = this.provider.authorize(access);
            if (delegate.isOk()) {
                Authorize auth = delegate.getAuthorize();
                HashMap<String, Object> map = new HashMap<String, Object>();
                BeanKit.beanToMap((Object)auth, map, (CopyOptions)CopyOptions.of().setTransientSupport(false).setIgnoreCase(true));
                map.forEach((k, v) -> params.put((String)k, v.toString()));
                Format.info(exchange, "AUTH_TOKEN_VALIDATED", "Token validated successfully for channel: " + context.getChannel().getType());
            } else {
                Format.error(exchange, "AUTH_TOKEN_FAILED", "Error code: " + delegate.getMessage().errcode + ", message: " + delegate.getMessage().errmsg);
                throw new BusinessException(delegate.getMessage().errcode, delegate.getMessage().errmsg);
            }
        }
    }

    protected void checkAppId(ServerWebExchange exchange, Assets assets, Map<String, String> requestParam) {
        String appId = assets.getMethod().split("\\.")[0];
        requestParam.putIfAbsent("x_app_id", appId);
        String xAppId = requestParam.get("x_app_id");
        if (StringKit.isNotBlank((CharSequence)xAppId) && !appId.equals(xAppId)) {
            Format.warn(exchange, "AUTH_APPID_MISMATCH", "App ID mismatch, expected: " + appId + ", actual: " + xAppId);
            throw new BusinessException(ErrorCode._100806);
        }
    }

    private void cleanParam(Map<String, String> params) {
        params.remove("method");
        params.remove("format");
        params.remove("v");
        params.remove("sign");
    }

    protected void fillXParam(ServerWebExchange exchange, Map<String, String> requestParam) {
        String ip = exchange.getRequest().getHeaders().getFirst("x_remote_ip");
        if (StringKit.isBlank((CharSequence)ip)) {
            ip = exchange.getRequest().getHeaders().getFirst("X-Forwarded-For");
            if (!StringKit.isBlank((CharSequence)ip)) {
                ip = ip.contains(",") ? ip.split(",")[0] : ip;
            } else {
                InetSocketAddress address = exchange.getRequest().getRemoteAddress();
                if (null != address) {
                    ip = address.getAddress().getHostAddress();
                }
            }
            requestParam.put("x_remote_ip", ip);
        }
    }
}

