/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.vortex.filter;

import jakarta.annotation.PostConstruct;
import java.nio.CharBuffer;
import java.util.Map;
import org.miaixz.bus.core.basic.entity.Message;
import org.miaixz.bus.core.lang.Algorithm;
import org.miaixz.bus.core.lang.Charset;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.crypto.Padding;
import org.miaixz.bus.crypto.builtin.symmetric.Crypto;
import org.miaixz.bus.crypto.center.AES;
import org.miaixz.bus.extra.json.JsonKit;
import org.miaixz.bus.vortex.Config;
import org.miaixz.bus.vortex.Context;
import org.miaixz.bus.vortex.Format;
import org.miaixz.bus.vortex.filter.AbstractFilter;
import org.reactivestreams.Publisher;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Order(value=-2147483647)
public class CipherFilter
extends AbstractFilter {
    private final Config.Decrypt decrypt;
    private final Config.Encrypt encrypt;
    private Crypto decryptCrypto;
    private Crypto encryptCrypto;

    public CipherFilter(Config.Decrypt decrypt, Config.Encrypt encrypt) {
        this.decrypt = decrypt;
        this.encrypt = encrypt;
    }

    @PostConstruct
    public void init() {
        if (this.decrypt.isEnabled() && Algorithm.AES.getValue().equals(this.decrypt.getType())) {
            this.decryptCrypto = new AES(Algorithm.Mode.CBC, Padding.PKCS7Padding, this.decrypt.getKey().getBytes(), this.decrypt.getOffset().getBytes());
        }
        if (this.encrypt.isEnabled() && Algorithm.AES.getValue().equals(this.encrypt.getType())) {
            this.encryptCrypto = new AES(Algorithm.Mode.CBC, Padding.PKCS7Padding, this.encrypt.getKey().getBytes(), this.encrypt.getOffset().getBytes());
        }
    }

    @Override
    protected Mono<Void> doFilter(ServerWebExchange exchange, WebFilterChain chain, Context context) {
        if (this.decrypt.isEnabled() && context.isNeedDecrypt()) {
            this.doDecrypt(exchange, this.getRequestMap(context));
            Format.info(exchange, "DECRYPT_PERFORMED", "Path: " + exchange.getRequest().getURI().getPath());
        } else if (this.encrypt.isEnabled() && (Format.XML.equals((Object)context.getFormat()) || Format.JSON.equals((Object)context.getFormat()))) {
            exchange = exchange.mutate().response((ServerHttpResponse)this.process(exchange)).build();
        }
        return chain.filter(exchange);
    }

    private void doDecrypt(ServerWebExchange exchange, Map<String, String> map) {
        if (null == this.decryptCrypto) {
            Format.warn(exchange, "DECRYPT_SKIPPED", "Decrypt crypto instance not initialized");
            return;
        }
        map.forEach((k, v) -> {
            if (StringKit.isNotBlank((CharSequence)v)) {
                map.put((String)k, this.decryptCrypto.decryptString(v.replaceAll(" ", "+"), Charset.UTF_8));
            }
        });
    }

    private void doEncrypt(Message message) {
        if (ObjectKit.isNotNull((Object)message.getData()) && Algorithm.AES.getValue().equals(this.encrypt.getType())) {
            message.setData((Object)this.encryptCrypto.encryptBase64(JsonKit.toJsonString((Object)message.getData()), Charset.UTF_8));
        }
    }

    private ServerHttpResponseDecorator process(final ServerWebExchange exchange) {
        return new ServerHttpResponseDecorator(exchange.getResponse()){

            public Mono<Void> writeWith(Publisher<? extends DataBuffer> body) {
                boolean isSign = CipherFilter.this.getAssets(CipherFilter.this.getContext(exchange)).isSign();
                if (isSign) {
                    Flux flux = Flux.from(body);
                    return super.writeWith((Publisher)DataBufferUtils.join((Publisher)flux).map(dataBuffer -> {
                        CharBuffer charBuffer = Charset.UTF_8.decode(dataBuffer.asByteBuffer());
                        DataBufferUtils.release((DataBuffer)dataBuffer);
                        Message message = (Message)JsonKit.toPojo((String)charBuffer.toString(), Message.class);
                        CipherFilter.this.doEncrypt(message);
                        String result = JsonKit.toJsonString((Object)message);
                        Format.info(exchange, "ENCRYPT_PERFORMED", "Path: " + exchange.getRequest().getURI().getPath());
                        return this.bufferFactory().wrap(result.getBytes());
                    }));
                }
                return super.writeWith(body);
            }
        };
    }
}

