/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.vortex.filter;

import java.nio.charset.Charset;
import org.miaixz.bus.vortex.Context;
import org.miaixz.bus.vortex.Format;
import org.miaixz.bus.vortex.filter.AbstractFilter;
import org.reactivestreams.Publisher;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Order(value=0x7FFFFFFD)
public class FormatFilter
extends AbstractFilter {
    @Override
    protected Mono<Void> doFilter(ServerWebExchange exchange, WebFilterChain chain, Context context) {
        Format.info(exchange, "REQUEST_START", "Method: " + String.valueOf(exchange.getRequest().getMethod()) + ", Path: " + exchange.getRequest().getPath().value() + ", Query: " + String.valueOf(exchange.getRequest().getQueryParams()));
        if (Format.XML.equals((Object)context.getFormat())) {
            Format.info(exchange, "FORMAT_CONVERT_TO_JSON", "Converting XML request to JSON response");
            exchange = exchange.mutate().response((ServerHttpResponse)this.process(exchange)).build();
        }
        return chain.filter(exchange);
    }

    private ServerHttpResponseDecorator process(final ServerWebExchange exchange) {
        return new ServerHttpResponseDecorator(this, exchange.getResponse()){

            public Mono<Void> writeWith(Publisher<? extends DataBuffer> body) {
                Flux flux = Flux.from(body);
                return super.writeWith((Publisher)DataBufferUtils.join((Publisher)flux).map(dataBuffer -> {
                    Context context = Context.get(exchange);
                    exchange.getResponse().getHeaders().setContentType(context.getFormat().getMediaType());
                    String bodyString = Charset.defaultCharset().decode(dataBuffer.asByteBuffer()).toString();
                    DataBufferUtils.release((DataBuffer)dataBuffer);
                    String formatBody = context.getFormat().getProvider().serialize(bodyString);
                    Format.trace(exchange, "RESPONSE_FORMATTED", formatBody);
                    return this.bufferFactory().wrap(formatBody.getBytes());
                }));
            }
        };
    }
}

