/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.vortex.filter;

import java.util.HashSet;
import java.util.Set;
import org.miaixz.bus.vortex.Context;
import org.miaixz.bus.vortex.Format;
import org.miaixz.bus.vortex.filter.AbstractFilter;
import org.miaixz.bus.vortex.magic.Limiter;
import org.miaixz.bus.vortex.registry.LimiterRegistry;
import org.springframework.core.annotation.Order;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

@Order(value=-2147483645)
public class LimitFilter
extends AbstractFilter {
    private final LimiterRegistry registry;

    public LimitFilter(LimiterRegistry registry) {
        this.registry = registry;
    }

    @Override
    protected Mono<Void> doFilter(ServerWebExchange exchange, WebFilterChain chain, Context context) {
        String ip = this.getRequestMap(context).get("x-remote_ip");
        String methodVersion = this.getAssets(context).getMethod() + this.getAssets(context).getVersion();
        Set<Limiter> cfgList = this.getLimiter(methodVersion, ip);
        for (Limiter cfg : cfgList) {
            cfg.acquire();
        }
        Format.info(exchange, "RATE_LIMIT_APPLIED", "Path: " + exchange.getRequest().getURI().getPath() + ", Method: " + methodVersion);
        return chain.filter(exchange);
    }

    private Set<Limiter> getLimiter(String methodVersion, String ip) {
        String[] limitKeys = new String[]{methodVersion, ip + methodVersion};
        HashSet<Limiter> limitCfgList = new HashSet<Limiter>();
        for (String limitKey : limitKeys) {
            Limiter limitCfg = (Limiter)this.registry.get(limitKey);
            if (null == limitCfg) continue;
            limitCfgList.add(limitCfg);
        }
        return limitCfgList;
    }
}

