/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.vortex.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.miaixz.bus.core.lang.Charset;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.extra.json.JsonKit;
import org.miaixz.bus.vortex.Context;
import org.miaixz.bus.vortex.Format;
import org.miaixz.bus.vortex.filter.AbstractFilter;
import org.miaixz.bus.vortex.magic.ErrorCode;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.codec.multipart.FilePart;
import org.springframework.http.codec.multipart.FormFieldPart;
import org.springframework.http.codec.multipart.Part;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Order(value=-2147483648)
public class PrimaryFilter
extends AbstractFilter {
    private static final List<String> BLOCKED_PATHS = Arrays.asList("/favicon.ico", "/robots.txt", "/sitemap.xml", "/apple-touch-icon.png", "/apple-touch-icon-precomposed.png", "/.well-known/appspecific/com.chrome.devtools.json");

    @Override
    protected Mono<Void> doFilter(ServerWebExchange exchange, WebFilterChain chain, Context context) {
        String path = exchange.getRequest().getPath().value();
        if (BLOCKED_PATHS.contains(path)) {
            Format.warn(exchange, "BLOCKED_REQUEST", "Blocked request to path: " + path);
            throw new InternalException(ErrorCode._BLOCKED);
        }
        if (this.isPathTraversalAttempt(path)) {
            Format.warn(exchange, "PATH_TRAVERSAL_ATTEMPT", "Path traversal attempt detected: " + path);
            throw new InternalException(ErrorCode._BLOCKED);
        }
        ServerWebExchange mutate = this.setContentType(exchange);
        context.setStartTime(System.currentTimeMillis());
        ServerHttpRequest request = mutate.getRequest();
        if (Objects.equals(request.getMethod(), HttpMethod.GET)) {
            MultiValueMap params = request.getQueryParams();
            context.setRequestMap(params.toSingleValueMap());
            this.checkParams(mutate);
            Format.info(mutate, "GET_PARAMS_PROCESSED", "Path: " + request.getURI().getPath() + ", Params: " + JsonKit.toJsonString(context.getRequestMap()));
            return chain.filter(mutate).doOnSuccess(v -> Format.info(mutate, "REQUEST_PROCESSED", "Path: " + request.getURI().getPath() + ", ExecutionTime: " + (System.currentTimeMillis() - context.getStartTime()) + "ms"));
        }
        MediaType contentType = mutate.getRequest().getHeaders().getContentType();
        return mutate.getRequest().getBody().collectList().flatMap(dataBuffers -> {
            final ArrayList<DataBuffer> originalBuffers = new ArrayList<DataBuffer>((Collection<DataBuffer>)dataBuffers);
            ServerHttpRequestDecorator newRequest = new ServerHttpRequestDecorator(this, mutate.getRequest()){

                public Flux<DataBuffer> getBody() {
                    return Flux.fromIterable((Iterable)originalBuffers);
                }
            };
            ServerWebExchange newExchange = mutate.mutate().request((ServerHttpRequest)newRequest).build();
            if (MediaType.APPLICATION_JSON.isCompatibleWith(contentType)) {
                return this.handleJsonRequest(newExchange, chain, context, originalBuffers);
            }
            if (MediaType.MULTIPART_FORM_DATA.isCompatibleWith(contentType)) {
                return this.handleMultipartRequest(newExchange, chain, context);
            }
            return this.handleFormRequest(newExchange, chain, context);
        });
    }

    private Mono<Void> handleJsonRequest(ServerWebExchange exchange, WebFilterChain chain, Context context, List<DataBuffer> originalBuffers) {
        String jsonBody = originalBuffers.stream().map(dataBuffer -> dataBuffer.toString(Charset.UTF_8)).collect(Collectors.joining());
        try {
            Map jsonMap = JsonKit.toMap((String)jsonBody);
            context.setRequestMap(jsonMap);
            this.checkParams(exchange);
            Format.info(exchange, "JSON_PARAMS_PROCESSED", "Path: " + exchange.getRequest().getURI().getPath() + ", Params: " + JsonKit.toJsonString((Object)jsonMap));
            return chain.filter(exchange).doOnTerminate(() -> Format.info(exchange, "REQUEST_PROCESSED", "Path: " + exchange.getRequest().getURI().getPath() + ", ExecutionTime: " + (System.currentTimeMillis() - context.getStartTime()) + "ms"));
        }
        catch (Exception e) {
            Format.warn(exchange, "JSON_PARSING_ERROR", "Failed to parse JSON: " + e.getMessage());
            throw new InternalException(ErrorCode._100302);
        }
    }

    private Mono<Void> handleFormRequest(ServerWebExchange exchange, WebFilterChain chain, Context context) {
        return exchange.getFormData().flatMap(params -> {
            context.setRequestMap(params.toSingleValueMap());
            this.checkParams(exchange);
            Format.info(exchange, "FORM_PARAMS_PROCESSED", "Path: " + exchange.getRequest().getURI().getPath() + ", Params: " + JsonKit.toJsonString(context.getRequestMap()));
            return chain.filter(exchange).doOnTerminate(() -> Format.info(exchange, "REQUEST_PROCESSED", "Path: " + exchange.getRequest().getURI().getPath() + ", ExecutionTime: " + (System.currentTimeMillis() - context.getStartTime()) + "ms"));
        });
    }

    private Mono<Void> handleMultipartRequest(ServerWebExchange exchange, WebFilterChain chain, Context context) {
        return exchange.getMultipartData().flatMap(params -> {
            LinkedHashMap<String, String> formMap = new LinkedHashMap<String, String>();
            LinkedHashMap<String, Part> fileMap = new LinkedHashMap<String, Part>();
            Map map = params.toSingleValueMap();
            map.forEach((k, v) -> {
                if (v instanceof FormFieldPart) {
                    formMap.put((String)k, ((FormFieldPart)v).value());
                }
                if (v instanceof FilePart) {
                    fileMap.put((String)k, (Part)v);
                }
            });
            context.setRequestMap(formMap);
            context.setFilePartMap(fileMap);
            this.checkParams(exchange);
            Format.info(exchange, "MULTIPART_PARAMS_PROCESSED", "Path: " + exchange.getRequest().getURI().getPath() + ", Params: " + JsonKit.toJsonString(formMap));
            return chain.filter(exchange).doOnTerminate(() -> Format.info(exchange, "REQUEST_PROCESSED", "Path: " + exchange.getRequest().getURI().getPath() + ", ExecutionTime: " + (System.currentTimeMillis() - context.getStartTime()) + "ms"));
        });
    }

    private boolean isPathTraversalAttempt(String path) {
        return path.contains("../") || path.contains("..\\") || path.contains("%2e%2e%2f") || path.contains("%2e%2e\\") || path.contains("..%2f") || path.contains("..%5c");
    }
}

