/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.vortex.handler;

import java.net.UnknownHostException;
import lombok.Generated;
import org.miaixz.bus.core.lang.exception.BusinessException;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.vortex.Context;
import org.miaixz.bus.vortex.Format;
import org.miaixz.bus.vortex.magic.ErrorCode;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.reactive.function.client.WebClientException;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebExceptionHandler;
import reactor.core.publisher.Mono;
import reactor.util.annotation.NonNull;

public class ErrorsHandler
implements WebExceptionHandler {
    @NonNull
    public Mono<Void> handle(ServerWebExchange exchange, Throwable ex) {
        Message message;
        ServerHttpResponse response = exchange.getResponse();
        response.setStatusCode((HttpStatusCode)HttpStatus.OK);
        response.getHeaders().setContentType(MediaType.APPLICATION_JSON);
        Context context = Context.get(exchange);
        if (ex instanceof WebClientException) {
            if (ex.getCause() instanceof UnknownHostException) {
                message = Message.builder().errcode(ErrorCode._80010001.getKey()).errmsg(ErrorCode._80010001.getValue()).build();
                Format.error(exchange, "WEBCLIENT_EXCEPTION", "UnknownHostException: " + ex.getMessage());
            } else {
                message = Message.builder().errcode(ErrorCode._80010002.getKey()).errmsg(ErrorCode._80010002.getValue()).build();
                Format.error(exchange, "WEBCLIENT_EXCEPTION", "WebClientException: " + ex.getMessage());
            }
        } else if (ex instanceof BusinessException) {
            BusinessException e = (BusinessException)ex;
            if (StringKit.isNotBlank((CharSequence)e.getErrcode())) {
                message = Message.builder().errcode(e.getErrcode()).errmsg(e.getErrmsg()).build();
                Format.error(exchange, "BUSINESS_EXCEPTION", "ErrorCode: " + e.getErrcode() + ", Message: " + e.getMessage());
            } else {
                message = Message.builder().errcode(ErrorCode._100807.getKey()).errmsg(ErrorCode._100807.getValue()).build();
                Format.error(exchange, "BUSINESS_EXCEPTION", "Generic BusinessException: " + e.getMessage());
            }
        } else {
            message = Message.builder().errcode(ErrorCode._100807.getKey()).errmsg(ErrorCode._100807.getValue()).build();
            Format.error(exchange, "UNKNOWN_EXCEPTION", "Unknown exception type: " + ex.getClass().getName() + ", Message: " + ex.getMessage());
        }
        String formatBody = context.getFormat().getProvider().serialize(message);
        DataBuffer db = response.bufferFactory().wrap(formatBody.getBytes());
        return response.writeWith((Publisher)Mono.just((Object)db)).doOnTerminate(() -> {
            if (context != null) {
                Format.info(exchange, "ERROR_HANDLED", "Error handled, execution time: " + (System.currentTimeMillis() - context.getStartTime()) + "ms");
            }
        });
    }

    static class Message {
        public String errcode;
        public String errmsg;

        @Generated
        Message(String errcode, String errmsg) {
            this.errcode = errcode;
            this.errmsg = errmsg;
        }

        @Generated
        public static MessageBuilder builder() {
            return new MessageBuilder();
        }

        @Generated
        public String getErrcode() {
            return this.errcode;
        }

        @Generated
        public String getErrmsg() {
            return this.errmsg;
        }

        @Generated
        public void setErrcode(String errcode) {
            this.errcode = errcode;
        }

        @Generated
        public void setErrmsg(String errmsg) {
            this.errmsg = errmsg;
        }

        @Generated
        public static class MessageBuilder {
            @Generated
            private String errcode;
            @Generated
            private String errmsg;

            @Generated
            MessageBuilder() {
            }

            @Generated
            public MessageBuilder errcode(String errcode) {
                this.errcode = errcode;
                return this;
            }

            @Generated
            public MessageBuilder errmsg(String errmsg) {
                this.errmsg = errmsg;
                return this;
            }

            @Generated
            public Message build() {
                return new Message(this.errcode, this.errmsg);
            }

            @Generated
            public String toString() {
                return "ErrorsHandler.Message.MessageBuilder(errcode=" + this.errcode + ", errmsg=" + this.errmsg + ")";
            }
        }
    }
}

