/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.vortex.registry;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.miaixz.bus.vortex.Registry;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractRegistry<T>
implements Registry<T>,
InitializingBean {
    private final Map<String, T> cache = new ConcurrentHashMap<String, T>();
    protected RegistryKey<T> registryKey;

    protected void setKeyGenerator(RegistryKey<T> registryKey) {
        this.registryKey = registryKey;
    }

    @Override
    public abstract void init();

    @Override
    public boolean add(String key, T reg) {
        if (null != this.cache.get(key)) {
            return false;
        }
        this.cache.put(key, reg);
        return true;
    }

    public boolean add(T item) {
        if (this.registryKey == null) {
            throw new IllegalStateException("Key generator not set");
        }
        return this.add(this.registryKey.keys(item), item);
    }

    @Override
    public boolean remove(String id) {
        return null != this.cache.remove(id);
    }

    @Override
    public boolean amend(String key, T reg) {
        this.cache.remove(key);
        return this.add(key, reg);
    }

    public boolean amend(T item) {
        if (this.registryKey == null) {
            throw new IllegalStateException("Key generator not set");
        }
        return this.amend(this.registryKey.keys(item), item);
    }

    @Override
    public void refresh() {
        this.cache.clear();
        this.init();
    }

    @Override
    public T get(String key) {
        return this.cache.get(key);
    }

    public void afterPropertiesSet() {
        this.refresh();
    }

    @FunctionalInterface
    public static interface RegistryKey<T> {
        public String keys(T var1);
    }
}

