/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.vortex.support;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.miaixz.bus.vortex.Assets;
import org.miaixz.bus.vortex.Config;
import org.miaixz.bus.vortex.Context;
import org.miaixz.bus.vortex.Format;
import org.miaixz.bus.vortex.Router;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.codec.multipart.Part;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClientRequest;
import reactor.util.annotation.NonNull;

public class HttpRequestRouter
implements Router {
    private static final ExchangeStrategies CACHED_EXCHANGE_STRATEGIES = ExchangeStrategies.builder().codecs(configurer -> configurer.defaultCodecs().maxInMemorySize(Config.MAX_INMEMORY_SIZE.intValue())).build();
    private final Map<String, WebClient> clients = new ConcurrentHashMap<String, WebClient>();

    @Override
    @NonNull
    public Mono<ServerResponse> route(ServerRequest request, Context context, Assets assets) {
        String baseUrl = this.buildBaseUrl(assets);
        WebClient webClient = this.clients.computeIfAbsent(baseUrl, client -> WebClient.builder().exchangeStrategies(CACHED_EXCHANGE_STRATEGIES).baseUrl(baseUrl).build());
        String targetUri = this.buildTargetUri(assets, context);
        WebClient.RequestBodySpec bodySpec = (WebClient.RequestBodySpec)webClient.method(assets.getHttpMethod()).uri(targetUri, new Object[0]);
        bodySpec.headers(headers -> {
            headers.addAll((MultiValueMap)request.headers().asHttpHeaders());
            headers.remove((Object)"Host");
            headers.clearContentHeaders();
        });
        if (!HttpMethod.GET.equals((Object)assets.getHttpMethod())) {
            MediaType mediaType = request.headers().contentType().orElse(null);
            if (mediaType != null) {
                if (MediaType.MULTIPART_FORM_DATA.isCompatibleWith(mediaType)) {
                    Map<String, Part> fileParts = context.getFilePartMap();
                    Map<String, String> params = context.getRequestMap();
                    if (!fileParts.isEmpty() || !params.isEmpty()) {
                        LinkedMultiValueMap partMap = new LinkedMultiValueMap(fileParts.size());
                        partMap.setAll(fileParts);
                        BodyInserters.MultipartInserter multipartInserter = BodyInserters.fromMultipartData((MultiValueMap)partMap);
                        if (!params.isEmpty()) {
                            params.forEach((arg_0, arg_1) -> ((BodyInserters.MultipartInserter)multipartInserter).with(arg_0, arg_1));
                        }
                        bodySpec.body((BodyInserter)multipartInserter);
                    }
                } else {
                    if (MediaType.APPLICATION_JSON.isCompatibleWith(mediaType)) {
                        return request.bodyToMono(String.class).defaultIfEmpty((Object)"").flatMap(jsonBody -> {
                            Format.debug(request.exchange(), "JSON_REQUEST_BODY", "JSON request body size: " + jsonBody.length());
                            return bodySpec.contentType(MediaType.APPLICATION_JSON).bodyValue(jsonBody).httpRequest(clientHttpRequest -> {
                                HttpClientRequest reactorRequest = (HttpClientRequest)clientHttpRequest.getNativeRequest();
                                reactorRequest.responseTimeout(Duration.ofMillis(assets.getTimeout()));
                            }).retrieve().toEntity(DataBuffer.class).flatMap(this::processResponse);
                        });
                    }
                    if (MediaType.APPLICATION_FORM_URLENCODED.isCompatibleWith(mediaType)) {
                        this.handleFormRequestBody(bodySpec, context);
                    } else {
                        Format.warn(request.exchange(), "UNSUPPORTED_MEDIA_TYPE", "Unsupported media type: " + String.valueOf(mediaType));
                        this.handleFormRequestBody(bodySpec, context);
                    }
                }
            } else {
                this.handleFormRequestBody(bodySpec, context);
            }
        }
        return ((WebClient.RequestBodySpec)bodySpec.httpRequest(clientHttpRequest -> {
            HttpClientRequest reactorRequest = (HttpClientRequest)clientHttpRequest.getNativeRequest();
            reactorRequest.responseTimeout(Duration.ofMillis(assets.getTimeout()));
        })).retrieve().toEntity(DataBuffer.class).flatMap(this::processResponse);
    }

    private void handleFormRequestBody(WebClient.RequestBodySpec bodySpec, Context context) {
        Map<String, String> params = context.getRequestMap();
        if (!params.isEmpty()) {
            LinkedMultiValueMap multiValueMap = new LinkedMultiValueMap(params.size());
            params.forEach((arg_0, arg_1) -> ((MultiValueMap)multiValueMap).add(arg_0, arg_1));
            bodySpec.contentType(MediaType.APPLICATION_FORM_URLENCODED).bodyValue((Object)multiValueMap);
        }
    }

    private String buildBaseUrl(Assets assets) {
        StringBuilder baseUrlBuilder = new StringBuilder(assets.getHost());
        if (assets.getPort() > 0) {
            baseUrlBuilder.append(":").append(assets.getPort());
        }
        if (assets.getPath() != null && !assets.getPath().isEmpty()) {
            if (!assets.getPath().startsWith("/")) {
                baseUrlBuilder.append("/");
            }
            baseUrlBuilder.append(assets.getPath());
        }
        return baseUrlBuilder.toString();
    }

    private String buildTargetUri(Assets assets, Context context) {
        Map<String, String> params;
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)assets.getUrl());
        if (HttpMethod.GET.equals((Object)assets.getHttpMethod()) && !(params = context.getRequestMap()).isEmpty()) {
            LinkedMultiValueMap multiValueMap = new LinkedMultiValueMap(params.size());
            params.forEach((arg_0, arg_1) -> ((MultiValueMap)multiValueMap).add(arg_0, arg_1));
            builder.queryParams((MultiValueMap)multiValueMap);
        }
        return builder.build().encode().toUriString();
    }

    private Mono<ServerResponse> processResponse(ResponseEntity<DataBuffer> responseEntity) {
        return ((ServerResponse.BodyBuilder)ServerResponse.ok().headers(headers -> {
            headers.addAll((MultiValueMap)responseEntity.getHeaders());
            headers.remove((Object)"Content-Length");
        })).body(responseEntity.getBody() == null ? BodyInserters.empty() : BodyInserters.fromDataBuffers((Publisher)Flux.just((Object)((DataBuffer)responseEntity.getBody()))));
    }
}

