/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.vortex.filter;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import org.miaixz.bus.core.lang.exception.ValidateException;
import org.miaixz.bus.core.net.Protocol;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.vortex.Assets;
import org.miaixz.bus.vortex.Context;
import org.miaixz.bus.vortex.Filter;
import org.miaixz.bus.vortex.Format;
import org.miaixz.bus.vortex.magic.ErrorCode;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public abstract class AbstractFilter
implements Filter {
    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        Format.info(exchange, "FILTER_ENTER", "Entering filter: " + this.getClass().getSimpleName());
        return this.doFilter(exchange, chain, this.getContext(exchange)).doOnTerminate(() -> Format.debug(exchange, "FILTER_EXIT", "Exiting filter: " + this.getClass().getSimpleName())).doOnError(e -> Format.error(exchange, "FILTER_ERROR", "Error in " + this.getClass().getSimpleName() + ": " + e.getMessage()));
    }

    protected abstract Mono<Void> doFilter(ServerWebExchange var1, WebFilterChain var2, Context var3);

    protected Context getContext(ServerWebExchange exchange) {
        Context context = Context.get(exchange);
        if (context == null) {
            throw new ValidateException(ErrorCode._100805);
        }
        context.setHttpMethod(exchange.getRequest().getMethod());
        return context;
    }

    protected Assets getAssets(Context context) {
        if (context == null) {
            throw new ValidateException(ErrorCode._100805);
        }
        return context.getAssets();
    }

    protected Map<String, String> getRequestMap(Context context) {
        if (context == null) {
            throw new ValidateException(ErrorCode._100805);
        }
        return context.getRequestMap();
    }

    protected ServerWebExchange setContentType(ServerWebExchange exchange) {
        ServerHttpRequest request = exchange.getRequest();
        MediaType mediaType = request.getHeaders().getContentType();
        if (null == mediaType) {
            mediaType = MediaType.APPLICATION_FORM_URLENCODED;
            final HttpHeaders headers = new HttpHeaders();
            headers.putAll((Map)exchange.getRequest().getHeaders());
            headers.setContentType(mediaType);
            ServerHttpRequestDecorator requestDecorator = new ServerHttpRequestDecorator(this, request){

                public HttpHeaders getHeaders() {
                    return headers;
                }
            };
            return exchange.mutate().request((ServerHttpRequest)requestDecorator).build();
        }
        return exchange;
    }

    public static Optional<String> getOriginalAuthority(ServerHttpRequest request) {
        Optional<String> authority;
        HttpHeaders headers = request.getHeaders();
        String protocol = AbstractFilter.getOriginalProtocol(request);
        String forwardedHeader = headers.getFirst("Forwarded");
        if (StringKit.hasText((String)forwardedHeader) && (authority = Arrays.stream(forwardedHeader.split(";")).map(String::trim).filter(part -> part.toLowerCase().startsWith("host=")).map(part -> part.substring(5).trim().replace("\"", "")).findFirst()).isPresent()) {
            Logger.debug((String)"Authority '{}' found in 'Forwarded' header.", (Object[])new Object[]{authority.get()});
            return authority.map(host -> AbstractFilter.appendPortIfMissing(host, protocol));
        }
        String forwardedHostHeader = headers.getFirst("X-Forwarded-Host");
        if (StringKit.hasText((String)forwardedHostHeader)) {
            String authority2 = forwardedHostHeader.split(",")[0].trim();
            Logger.debug((String)"Authority '{}' found in 'X-Forwarded-Host' header.", (Object[])new Object[]{authority2});
            return Optional.of(AbstractFilter.appendPortIfMissing(authority2, protocol));
        }
        String hostHeader = headers.getFirst("Host");
        if (StringKit.hasText((String)hostHeader)) {
            Logger.debug((String)"Authority '{}' found in 'Host' header.", (Object[])new Object[]{hostHeader});
            return Optional.of(AbstractFilter.appendPortIfMissing(hostHeader, protocol));
        }
        String uriHost = request.getURI().getHost();
        if (StringKit.hasText((String)uriHost)) {
            Logger.debug((String)"Authority host '{}' found via request.getURI().getHost() as fallback.", (Object[])new Object[]{uriHost});
            return Optional.of(AbstractFilter.appendPortIfMissing(uriHost, protocol));
        }
        Logger.warn((String)"Could not determine a valid authority from any source for request: {}", (Object[])new Object[]{request.getPath()});
        return Optional.empty();
    }

    protected static String getOriginalProtocol(ServerHttpRequest request) {
        Optional<String> proto;
        HttpHeaders headers = request.getHeaders();
        String forwardedHeader = headers.getFirst("Forwarded");
        if (StringKit.hasText((String)forwardedHeader) && (proto = Arrays.stream(forwardedHeader.split(";")).map(String::trim).filter(part -> part.toLowerCase().startsWith("proto=")).map(part -> part.substring(6).trim().replace("\"", "")).findFirst()).isPresent()) {
            return proto.get();
        }
        String forwardedProtoHeader = headers.getFirst("X-Forwarded-Proto");
        if (StringKit.hasText((String)forwardedProtoHeader)) {
            return forwardedProtoHeader.split(",")[0].trim();
        }
        return request.getURI().getScheme();
    }

    protected void validate(ServerWebExchange exchange) {
        Context context = this.getContext(exchange);
        Map<String, String> params = this.getRequestMap(context);
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (entry.getKey() != null && "undefined".equals(entry.getKey().toLowerCase())) {
                throw new ValidateException(ErrorCode._100101);
            }
            if (!(entry.getValue() instanceof String) || !"undefined".equals(entry.getValue().toLowerCase())) continue;
            throw new ValidateException(ErrorCode._100101);
        }
        if (StringKit.isBlank((CharSequence)params.get("method"))) {
            throw new ValidateException(ErrorCode._100108);
        }
        if (StringKit.isBlank((CharSequence)params.get("v"))) {
            throw new ValidateException(ErrorCode._100107);
        }
        if (StringKit.isBlank((CharSequence)params.get("format"))) {
            throw new ValidateException(ErrorCode._100111);
        }
        if (StringKit.isNotBlank((CharSequence)params.get("sign"))) {
            context.setSign(Integer.valueOf(params.get("sign")));
        }
    }

    public HttpMethod valueOf(int type) {
        switch (type) {
            case 1: {
                return HttpMethod.GET;
            }
            case 2: {
                return HttpMethod.POST;
            }
            case 3: {
                return HttpMethod.HEAD;
            }
            case 4: {
                return HttpMethod.PUT;
            }
            case 5: {
                return HttpMethod.PATCH;
            }
            case 6: {
                return HttpMethod.DELETE;
            }
            case 7: {
                return HttpMethod.OPTIONS;
            }
            case 8: {
                return HttpMethod.TRACE;
            }
        }
        throw new ValidateException(ErrorCode._100802);
    }

    private static String appendPortIfMissing(String authority, String protocol) {
        if (authority.contains(":")) {
            return authority;
        }
        if (Protocol.HTTPS.name.equalsIgnoreCase(protocol)) {
            return authority + ":443";
        }
        return authority + ":80";
    }
}

