/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.vortex.filter;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.miaixz.bus.core.basic.entity.Authorize;
import org.miaixz.bus.core.basic.normal.Consts;
import org.miaixz.bus.core.basic.normal.Errors;
import org.miaixz.bus.core.bean.copier.CopyOptions;
import org.miaixz.bus.core.lang.exception.ValidateException;
import org.miaixz.bus.core.xyz.BeanKit;
import org.miaixz.bus.core.xyz.MapKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.vortex.Assets;
import org.miaixz.bus.vortex.Channel;
import org.miaixz.bus.vortex.Context;
import org.miaixz.bus.vortex.Format;
import org.miaixz.bus.vortex.filter.AbstractFilter;
import org.miaixz.bus.vortex.magic.Delegate;
import org.miaixz.bus.vortex.magic.ErrorCode;
import org.miaixz.bus.vortex.magic.Principal;
import org.miaixz.bus.vortex.provider.AuthorizeProvider;
import org.miaixz.bus.vortex.registry.AssetsRegistry;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

@Order(value=-2147483646)
public class AuthorizeFilter
extends AbstractFilter {
    private final AuthorizeProvider provider;
    private final AssetsRegistry registry;

    public AuthorizeFilter(AuthorizeProvider provider, AssetsRegistry registry) {
        this.provider = provider;
        this.registry = registry;
    }

    @Override
    protected Mono<Void> doFilter(ServerWebExchange exchange, WebFilterChain chain, Context context) {
        Map<String, String> params = this.getRequestMap(context);
        context.setFormat(Format.valueOf(StringKit.toUpperCase((CharSequence)params.get("format"))));
        context.setChannel(Channel.get(params.get("x_remote_channel")));
        context.setToken(exchange.getRequest().getHeaders().getFirst("X-Access-Token"));
        String method = params.get("method");
        String version = params.get("v");
        Assets assets = this.registry.get(method, version);
        if (null == assets) {
            Format.warn(exchange, "AUTH_ASSETS_NOT_FOUND", "Assets not found for method: " + method + ", version: " + version);
            return Mono.error((Throwable)new ValidateException(ErrorCode._100800));
        }
        this.method(exchange, assets);
        if (Consts.TYPE_ONE != assets.getFirewall()) {
            this.authorize(exchange, context, assets);
        }
        context.setAssets(assets);
        Format.info(exchange, "AUTH_VALIDATED", "Method: " + method + ", Version: " + version);
        return chain.filter(exchange);
    }

    protected void method(ServerWebExchange exchange, Assets assets) {
        ServerHttpRequest request = exchange.getRequest();
        HttpMethod expectedMethod = this.valueOf(assets.getType());
        if (!Objects.equals(request.getMethod(), expectedMethod)) {
            String errors = "HTTP method mismatch, expected: " + String.valueOf(expectedMethod) + ", actual: " + String.valueOf(request.getMethod());
            Format.warn(exchange, "AUTH_METHOD_MISMATCH", errors);
            Errors error = switch (expectedMethod.name()) {
                case "GET" -> ErrorCode._100200;
                case "POST" -> ErrorCode._100201;
                case "PUT" -> ErrorCode._100202;
                case "DELETE" -> ErrorCode._100203;
                case "OPTIONS" -> ErrorCode._100204;
                case "HEAD" -> ErrorCode._100205;
                case "PATCH" -> ErrorCode._100206;
                case "TRACE" -> ErrorCode._100207;
                default -> ErrorCode._100802;
            };
            throw new ValidateException(error);
        }
    }

    protected void authorize(ServerWebExchange exchange, Context context, Assets assets) {
        if (Consts.TYPE_ONE == assets.getToken()) {
            if (StringKit.isBlank((CharSequence)context.getToken())) {
                Format.warn(exchange, "AUTH_TOKEN_MISSING", "Access token is missing");
                throw new ValidateException(ErrorCode._100106);
            }
            Delegate delegate = this.provider.authorize((Principal)((Principal.PrincipalBuilder)((Principal.PrincipalBuilder)((Principal.PrincipalBuilder)((Principal.PrincipalBuilder)Principal.builder().type(Consts.TYPE_ONE)).value(context.getToken())).channel(context.getChannel().getType())).assets(assets)).build());
            if (delegate.isOk()) {
                Authorize auth = delegate.getAuthorize();
                HashMap<String, Object> map = new HashMap<String, Object>();
                BeanKit.beanToMap((Object)auth, map, (CopyOptions)CopyOptions.of().setTransientSupport(false).setIgnoreCase(true));
                map.forEach((k, v) -> context.getRequestMap().put((String)k, v.toString()));
                Format.info(exchange, "AUTH_TOKEN_VALIDATED", "Token validated successfully for channel: " + context.getChannel().getType());
            } else {
                Format.error(exchange, "AUTH_TOKEN_FAILED", "Error code: " + delegate.getMessage().errcode + ", message: " + delegate.getMessage().errmsg);
                throw new ValidateException(delegate.getMessage().errcode, delegate.getMessage().errmsg);
            }
        }
        if (Consts.TYPE_ONE == assets.getScope()) {
            Object[] api_key_params = new String[]{"apiKey", "api_key", "x_api_key", "api_id", "x_api_id", "X-API-ID", "X-API-KEY", "API-KEY", "API-ID"};
            String apiKey = (String)MapKit.getFirstNonNull(context.getRequestMap(), (Object[])api_key_params);
            if (StringKit.isBlank((CharSequence)apiKey)) {
                apiKey = (String)MapKit.getFirstNonNull(context.getHeaderMap(), (Object[])api_key_params);
            }
            if (StringKit.isBlank((CharSequence)apiKey)) {
                Format.warn(exchange, "AUTH_APIKEY_MISSING", "No Api Key provided in the request");
                throw new ValidateException(ErrorCode._100805);
            }
            Delegate delegate = this.provider.authorize((Principal)((Principal.PrincipalBuilder)((Principal.PrincipalBuilder)((Principal.PrincipalBuilder)((Principal.PrincipalBuilder)Principal.builder().type(Consts.TYPE_TWO)).value(apiKey)).channel(context.getChannel().getType())).assets(assets)).build());
            if (delegate.isOk()) {
                Authorize auth = delegate.getAuthorize();
                HashMap<String, Object> map = new HashMap<String, Object>();
                BeanKit.beanToMap((Object)auth, map, (CopyOptions)CopyOptions.of().setTransientSupport(false).setIgnoreCase(true));
                map.forEach((k, v) -> context.getRequestMap().put((String)k, v.toString()));
                Format.info(exchange, "AUTH_TOKEN_VALIDATED", "Token validated successfully for channel: " + context.getChannel().getType());
            } else {
                Format.error(exchange, "AUTH_TOKEN_FAILED", "Error code: " + delegate.getMessage().errcode + ", message: " + delegate.getMessage().errmsg);
                throw new ValidateException(delegate.getMessage().errcode, delegate.getMessage().errmsg);
            }
        }
    }
}

