/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.vortex.filter;

import jakarta.annotation.PostConstruct;
import java.util.List;
import java.util.Map;
import org.miaixz.bus.core.basic.entity.Message;
import org.miaixz.bus.core.basic.normal.Consts;
import org.miaixz.bus.core.lang.Algorithm;
import org.miaixz.bus.core.lang.Charset;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.crypto.Padding;
import org.miaixz.bus.crypto.builtin.symmetric.Crypto;
import org.miaixz.bus.crypto.center.AES;
import org.miaixz.bus.extra.json.JsonKit;
import org.miaixz.bus.vortex.Config;
import org.miaixz.bus.vortex.Context;
import org.miaixz.bus.vortex.Format;
import org.miaixz.bus.vortex.filter.AbstractFilter;
import org.reactivestreams.Publisher;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Order(value=-2147483647)
public class CipherFilter
extends AbstractFilter {
    private final Config.Decrypt decrypt;
    private final Config.Encrypt encrypt;
    private Crypto decryptCrypto;
    private Crypto encryptCrypto;

    public CipherFilter(Config.Decrypt decrypt, Config.Encrypt encrypt) {
        this.decrypt = decrypt;
        this.encrypt = encrypt;
    }

    @PostConstruct
    public void init() {
        if (this.decrypt.isEnabled() && Algorithm.AES.getValue().equals(this.decrypt.getType())) {
            this.decryptCrypto = new AES(Algorithm.Mode.CBC, Padding.PKCS7Padding, this.decrypt.getKey().getBytes(), this.decrypt.getOffset().getBytes());
        }
        if (this.encrypt.isEnabled() && Algorithm.AES.getValue().equals(this.encrypt.getType())) {
            this.encryptCrypto = new AES(Algorithm.Mode.CBC, Padding.PKCS7Padding, this.encrypt.getKey().getBytes(), this.encrypt.getOffset().getBytes());
        }
    }

    @Override
    protected Mono<Void> doFilter(ServerWebExchange exchange, WebFilterChain chain, Context context) {
        if (Consts.TYPE_ONE == context.getSign()) {
            if (this.decrypt.isEnabled()) {
                this.doDecrypt(exchange, this.getRequestMap(context));
                Format.info(exchange, "DECRYPT_PERFORMED", "Path: " + exchange.getRequest().getURI().getPath());
            }
            if (this.encrypt.isEnabled() && (Format.XML.equals((Object)context.getFormat()) || Format.JSON.equals((Object)context.getFormat()))) {
                exchange = exchange.mutate().response((ServerHttpResponse)this.process(exchange)).build();
            }
        }
        return chain.filter(exchange);
    }

    private void doDecrypt(ServerWebExchange exchange, Map<String, String> map) {
        if (null == this.decryptCrypto) {
            Format.warn(exchange, "DECRYPT_SKIPPED", "Decrypt crypto instance not initialized");
            return;
        }
        map.forEach((k, v) -> {
            if (StringKit.isNotBlank((CharSequence)v)) {
                map.put((String)k, this.decryptCrypto.decryptString(v.replaceAll(" ", "+"), Charset.UTF_8));
            }
        });
    }

    private void doEncrypt(Message message) {
        if (ObjectKit.isNotNull((Object)message.getData()) && Algorithm.AES.getValue().equals(this.encrypt.getType())) {
            message.setData((Object)this.encryptCrypto.encryptBase64(JsonKit.toJsonString((Object)message.getData()), Charset.UTF_8));
        }
    }

    private ServerHttpResponseDecorator process(final ServerWebExchange exchange) {
        return new ServerHttpResponseDecorator(exchange.getResponse()){

            public Mono<Void> writeWith(Publisher<? extends DataBuffer> body) {
                Integer isSign = CipherFilter.this.getAssets(CipherFilter.this.getContext(exchange)).getSign();
                if (Consts.TYPE_ONE == isSign) {
                    Flux flux = Flux.from(body);
                    return flux.collectList().flatMap(dataBuffers -> {
                        byte[] allBytes = CipherFilter.this.merge((List<? extends DataBuffer>)dataBuffers);
                        String responseBody = new String(allBytes, Charset.UTF_8);
                        Message message = (Message)JsonKit.toPojo((String)responseBody, Message.class);
                        CipherFilter.this.doEncrypt(message);
                        String result = JsonKit.toJsonString((Object)message);
                        Format.info(exchange, "ENCRYPT_PERFORMED", "Path: " + exchange.getRequest().getURI().getPath());
                        DataBufferFactory bufferFactory = this.bufferFactory();
                        DataBuffer encryptedBuffer = bufferFactory.wrap(result.getBytes(Charset.UTF_8));
                        return super.writeWith((Publisher)Mono.just((Object)encryptedBuffer));
                    });
                }
                return super.writeWith(body);
            }
        };
    }

    private byte[] merge(List<? extends DataBuffer> dataBuffers) {
        int totalBytes = dataBuffers.stream().mapToInt(DataBuffer::readableByteCount).sum();
        byte[] result = new byte[totalBytes];
        int position = 0;
        for (DataBuffer dataBuffer : dataBuffers) {
            int length = dataBuffer.readableByteCount();
            dataBuffer.read(result, position, length);
            position += length;
        }
        return result;
    }
}

