/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.vortex.filter;

import java.util.Optional;
import org.miaixz.bus.core.basic.normal.Consts;
import org.miaixz.bus.core.lang.exception.ValidateException;
import org.miaixz.bus.vortex.Assets;
import org.miaixz.bus.vortex.Context;
import org.miaixz.bus.vortex.Format;
import org.miaixz.bus.vortex.filter.AbstractFilter;
import org.miaixz.bus.vortex.magic.ErrorCode;
import org.miaixz.bus.vortex.provider.LicenseProvider;
import org.springframework.core.annotation.Order;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

@Order(value=-2147483644)
public class LicenseFilter
extends AbstractFilter {
    private final LicenseProvider provider;

    public LicenseFilter(LicenseProvider provider) {
        this.provider = provider;
    }

    @Override
    protected Mono<Void> doFilter(ServerWebExchange exchange, WebFilterChain chain, Context context) {
        Assets assets = this.getAssets(context);
        Optional<String> authorityOptional = LicenseFilter.getOriginalAuthority(exchange.getRequest());
        String authority = authorityOptional.orElseThrow(() -> {
            String errorMessage = "Unable to determine the request authority (host:port) for license validation. The request will be ignored.";
            Format.error(exchange, "LICENSE_AUTHORITY_NOT_FOUND", errorMessage);
            throw new ValidateException(ErrorCode._100527);
        });
        Format.info(exchange, "LICENSE_VALIDATING", "Validating license for authority: " + authority);
        if (Consts.TYPE_TWO == assets.getFirewall()) {
            this.provider.validate(authority);
        }
        return chain.filter(exchange);
    }
}

