/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.vortex.filter;

import java.time.Duration;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.miaixz.bus.core.lang.Charset;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.lang.exception.ValidateException;
import org.miaixz.bus.core.xyz.DateKit;
import org.miaixz.bus.extra.json.JsonKit;
import org.miaixz.bus.vortex.Context;
import org.miaixz.bus.vortex.Format;
import org.miaixz.bus.vortex.filter.AbstractFilter;
import org.miaixz.bus.vortex.magic.ErrorCode;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.codec.multipart.FilePart;
import org.springframework.http.codec.multipart.FormFieldPart;
import org.springframework.http.codec.multipart.Part;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;

@Order(value=-2147483648)
public class PrimaryFilter
extends AbstractFilter {
    private static final List<String> BLOCKED_PATHS = Arrays.asList("/favicon.ico", "/robots.txt", "/sitemap.xml", "/apple-touch-icon.png", "/apple-touch-icon-precomposed.png", "/.well-known/appspecific/com.chrome.devtools.json");
    private static final int MAX_RETRY_ATTEMPTS = 3;
    private static final long RETRY_DELAY_MS = 1000L;

    @Override
    protected Mono<Void> doFilter(ServerWebExchange exchange, WebFilterChain chain, Context context) {
        String path = exchange.getRequest().getPath().value();
        if (BLOCKED_PATHS.contains(path)) {
            Format.warn(exchange, "BLOCKED_REQUEST", "Blocked request to path: " + path);
            throw new ValidateException(ErrorCode._BLOCKED);
        }
        if (this.isPathTraversalAttempt(path)) {
            Format.warn(exchange, "PATH_TRAVERSAL_ATTEMPT", "Path traversal attempt detected: " + path);
            throw new ValidateException(ErrorCode._LIMITER);
        }
        ServerWebExchange mutate = this.setContentType(exchange);
        context.setTimestamp(DateKit.current());
        ServerHttpRequest request = mutate.getRequest();
        if (Objects.equals(request.getMethod(), HttpMethod.GET)) {
            return this.handleGetRequest(mutate, chain, context);
        }
        MediaType contentType = mutate.getRequest().getHeaders().getContentType();
        if (contentType == null) {
            return this.handleFormRequest(mutate, chain, context);
        }
        if (MediaType.APPLICATION_JSON.isCompatibleWith(contentType)) {
            return this.handleJsonRequest(mutate, chain, context);
        }
        if (MediaType.MULTIPART_FORM_DATA.isCompatibleWith(contentType)) {
            return this.handleMultipartRequest(mutate, chain, context);
        }
        if (MediaType.APPLICATION_FORM_URLENCODED.isCompatibleWith(contentType)) {
            return this.handleFormRequest(mutate, chain, context);
        }
        return this.handleFormRequest(mutate, chain, context);
    }

    private Mono<Void> handleGetRequest(ServerWebExchange exchange, WebFilterChain chain, Context context) {
        MultiValueMap params = exchange.getRequest().getQueryParams();
        context.setRequestMap(params.toSingleValueMap());
        this.validate(exchange);
        Format.info(exchange, "GET_PARAMS_PROCESSED", "Path: " + exchange.getRequest().getURI().getPath() + ", Params: " + JsonKit.toJsonString(context.getRequestMap()));
        return chain.filter(exchange).doOnSuccess(v -> Format.info(exchange, "REQUEST_PROCESSED", "Path: " + exchange.getRequest().getURI().getPath() + ", ExecutionTime: " + (System.currentTimeMillis() - context.getTimestamp()) + "ms"));
    }

    private Mono<Void> handleJsonRequest(ServerWebExchange exchange, WebFilterChain chain, Context context) {
        return exchange.getRequest().getBody().collectList().flatMap(dataBuffers -> this.processJsonData(exchange, chain, context, (List<DataBuffer>)dataBuffers)).retryWhen((Retry)Retry.backoff((long)3L, (Duration)Duration.ofMillis(1000L)).maxBackoff(Duration.ofMillis(500L)).jitter(0.75).doBeforeRetry(retrySignal -> Format.warn(exchange, "JSON_RETRY", "Retrying JSON request processing, attempt: " + (retrySignal.totalRetries() + 1L) + ", error: " + retrySignal.failure().getMessage())).onRetryExhaustedThrow((retryBackoffSpec, retrySignal) -> {
            Format.error(exchange, "JSON_RETRY_EXHAUSTED", "JSON request processing failed after 3 attempts, error: " + retrySignal.failure().getMessage());
            return new InternalException(ErrorCode._116000);
        }));
    }

    private Mono<Void> processJsonData(final ServerWebExchange exchange, WebFilterChain chain, Context context, List<DataBuffer> dataBuffers) {
        try {
            final byte[] bytes = new byte[dataBuffers.stream().mapToInt(DataBuffer::readableByteCount).sum()];
            int pos = 0;
            for (DataBuffer buffer : dataBuffers) {
                int length = buffer.readableByteCount();
                buffer.read(bytes, pos, length);
                pos += length;
            }
            String jsonBody = new String(bytes, Charset.UTF_8);
            Map jsonMap = JsonKit.toMap((String)jsonBody);
            context.setRequestMap(jsonMap);
            ServerHttpRequestDecorator newRequest = new ServerHttpRequestDecorator(this, exchange.getRequest()){

                public Flux<DataBuffer> getBody() {
                    DataBufferFactory bufferFactory = exchange.getResponse().bufferFactory();
                    return Flux.just((Object)bufferFactory.wrap(bytes));
                }
            };
            ServerWebExchange newExchange = exchange.mutate().request((ServerHttpRequest)newRequest).build();
            this.validate(newExchange);
            Format.info(newExchange, "JSON_PARAMS_PROCESSED", "Path: " + newExchange.getRequest().getURI().getPath() + ", Params: " + JsonKit.toJsonString((Object)jsonMap));
            return chain.filter(newExchange).doOnTerminate(() -> Format.info(newExchange, "REQUEST_PROCESSED", "Path: " + newExchange.getRequest().getURI().getPath() + ", ExecutionTime: " + (System.currentTimeMillis() - context.getTimestamp()) + "ms"));
        }
        catch (Exception e) {
            Format.error(exchange, "JSON_PROCESSING_ERROR", "Failed to process JSON: " + e.getMessage());
            return Mono.error((Throwable)e);
        }
    }

    private Mono<Void> handleFormRequest(ServerWebExchange exchange, WebFilterChain chain, Context context) {
        return exchange.getRequest().getBody().collectList().flatMap(dataBuffers -> this.processFormData(exchange, chain, context, (List<DataBuffer>)dataBuffers)).retryWhen((Retry)Retry.backoff((long)3L, (Duration)Duration.ofMillis(1000L)).maxBackoff(Duration.ofMillis(500L)).jitter(0.75).doBeforeRetry(retrySignal -> Format.warn(exchange, "FORM_RETRY", "Retrying form request processing, attempt: " + (retrySignal.totalRetries() + 1L) + ", error: " + retrySignal.failure().getMessage())).onRetryExhaustedThrow((retryBackoffSpec, retrySignal) -> {
            Format.error(exchange, "FORM_RETRY_EXHAUSTED", "Form request processing failed after 3 attempts, error: " + retrySignal.failure().getMessage());
            return new InternalException(ErrorCode._116000);
        }));
    }

    private Mono<Void> processFormData(final ServerWebExchange exchange, WebFilterChain chain, Context context, List<DataBuffer> dataBuffers) {
        try {
            final byte[] bytes = new byte[dataBuffers.stream().mapToInt(DataBuffer::readableByteCount).sum()];
            int pos = 0;
            for (DataBuffer buffer : dataBuffers) {
                int length = buffer.readableByteCount();
                buffer.read(bytes, pos, length);
                pos += length;
            }
            ServerHttpRequestDecorator newRequest = new ServerHttpRequestDecorator(this, exchange.getRequest()){

                public Flux<DataBuffer> getBody() {
                    DataBufferFactory bufferFactory = exchange.getResponse().bufferFactory();
                    return Flux.just((Object)bufferFactory.wrap(bytes));
                }
            };
            ServerWebExchange newExchange = exchange.mutate().request((ServerHttpRequest)newRequest).build();
            return newExchange.getFormData().flatMap(params -> {
                context.setRequestMap(params.toSingleValueMap());
                this.validate(newExchange);
                Format.info(newExchange, "FORM_PARAMS_PROCESSED", "Path: " + newExchange.getRequest().getURI().getPath() + ", Params: " + JsonKit.toJsonString(context.getRequestMap()));
                return chain.filter(newExchange).doOnTerminate(() -> Format.info(newExchange, "REQUEST_PROCESSED", "Path: " + newExchange.getRequest().getURI().getPath() + ", ExecutionTime: " + (System.currentTimeMillis() - context.getTimestamp()) + "ms"));
            });
        }
        catch (Exception e) {
            Format.error(exchange, "FORM_PROCESSING_ERROR", "Failed to process form: " + e.getMessage());
            return Mono.error((Throwable)e);
        }
    }

    private Mono<Void> handleMultipartRequest(ServerWebExchange exchange, WebFilterChain chain, Context context) {
        return exchange.getMultipartData().flatMap(params -> this.processMultipartData(exchange, chain, context, (MultiValueMap<String, Part>)params)).retryWhen((Retry)Retry.backoff((long)3L, (Duration)Duration.ofMillis(1000L)).maxBackoff(Duration.ofMillis(500L)).jitter(0.75).doBeforeRetry(retrySignal -> Format.warn(exchange, "MULTIPART_RETRY", "Retrying multipart request processing, attempt: " + (retrySignal.totalRetries() + 1L) + ", error: " + retrySignal.failure().getMessage())).onRetryExhaustedThrow((retryBackoffSpec, retrySignal) -> {
            Format.error(exchange, "MULTIPART_RETRY_EXHAUSTED", "Multipart request processing failed after 3 attempts, error: " + retrySignal.failure().getMessage());
            if (retrySignal.failure().getMessage() != null && retrySignal.failure().getMessage().contains("Could not find first boundary")) {
                return new InternalException(ErrorCode._100303);
            }
            return new InternalException(ErrorCode._116000);
        }));
    }

    private Mono<Void> processMultipartData(ServerWebExchange exchange, WebFilterChain chain, Context context, MultiValueMap<String, Part> params) {
        try {
            LinkedHashMap<String, String> formMap = new LinkedHashMap<String, String>();
            LinkedHashMap<String, Part> fileMap = new LinkedHashMap<String, Part>();
            params.toSingleValueMap().forEach((k, v) -> {
                if (v instanceof FormFieldPart) {
                    formMap.put((String)k, ((FormFieldPart)v).value());
                }
                if (v instanceof FilePart) {
                    fileMap.put((String)k, (Part)v);
                }
            });
            context.setRequestMap(formMap);
            context.setFilePartMap(fileMap);
            this.validate(exchange);
            Format.info(exchange, "MULTIPART_PARAMS_PROCESSED", "Path: " + exchange.getRequest().getURI().getPath() + ", Params: " + JsonKit.toJsonString(formMap));
            return chain.filter(exchange).doOnTerminate(() -> Format.info(exchange, "REQUEST_PROCESSED", "Path: " + exchange.getRequest().getURI().getPath() + ", ExecutionTime: " + (System.currentTimeMillis() - context.getTimestamp()) + "ms"));
        }
        catch (Exception e) {
            Format.error(exchange, "MULTIPART_PROCESSING_ERROR", "Failed to process multipart: " + e.getMessage());
            return Mono.error((Throwable)e);
        }
    }

    private boolean isPathTraversalAttempt(String path) {
        return path.contains("../") || path.contains("..\\") || path.contains("%2e%2e%2f") || path.contains("%2e%2e\\") || path.contains("..%2f") || path.contains("..%5c");
    }
}

