/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.vortex.handler;

import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.vortex.handler.AbstractHandler;
import org.springframework.core.annotation.Order;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Order(value=-2147483648)
public class AccessHandler
extends AbstractHandler {
    @Override
    public Mono<Boolean> preHandle(ServerWebExchange exchange, Object service, Object args) {
        return Mono.fromCallable(() -> {
            ServerHttpRequest request = exchange.getRequest();
            String path = request.getPath().value();
            String method = request.getMethod() != null ? request.getMethod().name() : "UNKNOWN";
            Logger.info((String)"[N/A] [{}] [{}] [ACCESS_PREHANDLE] - Performing async preHandle validation for request", (Object[])new Object[]{method, path});
            return true;
        });
    }

    @Override
    public Mono<Void> postHandle(ServerWebExchange exchange, Object service, Object args, Object result) {
        return Mono.fromRunnable(() -> {
            ServerHttpRequest request = exchange.getRequest();
            String path = request.getPath().value();
            String method = request.getMethod() != null ? request.getMethod().name() : "UNKNOWN";
            Logger.info((String)"[N/A] [{}] [{}] [ACCESS_POSTHANDLE] - Post-processing response for request", (Object[])new Object[]{method, path});
        });
    }

    @Override
    public Mono<Void> afterCompletion(ServerWebExchange exchange, Object service, Object args, Object result, Throwable exception) {
        return Mono.fromRunnable(() -> {
            ServerHttpRequest request = exchange.getRequest();
            String path = request.getPath().value();
            String method = request.getMethod() != null ? request.getMethod().name() : "UNKNOWN";
            String exceptionMsg = exception != null ? exception.getMessage() : "none";
            Logger.info((String)"[N/A] [{}] [{}] [ACCESS_COMPLETION] - Request completed, exception: {}", (Object[])new Object[]{method, path, exceptionMsg});
        });
    }
}

