/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.vortex.handler;

import java.net.UnknownHostException;
import lombok.Generated;
import org.miaixz.bus.core.lang.Charset;
import org.miaixz.bus.core.lang.exception.UncheckedException;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.vortex.Context;
import org.miaixz.bus.vortex.Format;
import org.miaixz.bus.vortex.magic.ErrorCode;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.reactive.function.client.WebClientException;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebExceptionHandler;
import reactor.core.publisher.Mono;
import reactor.util.annotation.NonNull;

public class ErrorsHandler
implements WebExceptionHandler {
    @NonNull
    public Mono<Void> handle(ServerWebExchange exchange, Throwable ex) {
        ServerHttpResponse response = exchange.getResponse();
        response.setStatusCode((HttpStatusCode)HttpStatus.OK);
        response.getHeaders().setContentType(MediaType.APPLICATION_JSON);
        Context context = Context.get(exchange);
        Message message = this.buildErrorMessage(ex, exchange);
        String formatBody = context.getFormat().getProvider().serialize(message);
        DataBuffer db = response.bufferFactory().wrap(formatBody.getBytes(Charset.UTF_8));
        return response.writeWith((Publisher)Mono.just((Object)db)).doOnTerminate(() -> this.logErrorHandling(exchange, context, ex));
    }

    protected Message buildErrorMessage(Throwable ex, ServerWebExchange exchange) {
        if (ex instanceof WebClientException) {
            return this.handleWebClientException((WebClientException)ex, exchange);
        }
        if (ex instanceof UncheckedException) {
            return this.handleUncheckedException((UncheckedException)ex, exchange);
        }
        return this.handleUnknownException(ex, exchange);
    }

    protected Message handleWebClientException(WebClientException ex, ServerWebExchange exchange) {
        if (ex.getCause() instanceof UnknownHostException) {
            Format.error(exchange, "WEBCLIENT_UNKNOWN_HOST", "UnknownHostException: " + ex.getCause().getMessage());
            return Message.builder().errcode(ErrorCode._100811.getKey()).errmsg(ErrorCode._100811.getValue()).build();
        }
        Format.error(exchange, "WEBCLIENT_EXCEPTION", "WebClientException: " + ex.getMessage());
        return Message.builder().errcode(ErrorCode._116000.getKey()).errmsg(ErrorCode._116000.getValue()).build();
    }

    protected Message handleUncheckedException(UncheckedException ex, ServerWebExchange exchange) {
        if (StringKit.isNotBlank((CharSequence)ex.getErrcode())) {
            Format.error(exchange, "INTERNAL_EXCEPTION", "ErrorCode: " + ex.getErrcode() + ", Message: " + ex.getErrmsg());
            return Message.builder().errcode(ex.getErrcode()).errmsg(ex.getErrmsg()).build();
        }
        Format.error(exchange, "INTERNAL_EXCEPTION", "Generic InternalException: " + ex.getMessage());
        return Message.builder().errcode(ErrorCode._100807.getKey()).errmsg(ErrorCode._100807.getValue()).build();
    }

    protected Message handleUnknownException(Throwable ex, ServerWebExchange exchange) {
        Format.error(exchange, "UNKNOWN_EXCEPTION", "Unknown exception type: " + ex.getClass().getName() + ", Message: " + ex.getMessage());
        return Message.builder().errcode(ErrorCode._100807.getKey()).errmsg(ErrorCode._100807.getValue()).build();
    }

    private void logErrorHandling(ServerWebExchange exchange, Context context, Throwable ex) {
        if (context != null) {
            long executionTime = System.currentTimeMillis() - context.getTimestamp();
            Format.info(exchange, "ERROR_HANDLED", "Error handled, execution time: " + executionTime + "ms, exception: " + ex.getClass().getSimpleName());
        } else {
            Format.info(exchange, "ERROR_HANDLED", "Error handled, exception: " + ex.getClass().getSimpleName());
        }
    }

    public static class Message {
        private String errcode;
        private String errmsg;

        @Generated
        public static MessageBuilder builder() {
            return new MessageBuilder();
        }

        @Generated
        public String getErrcode() {
            return this.errcode;
        }

        @Generated
        public String getErrmsg() {
            return this.errmsg;
        }

        @Generated
        public void setErrcode(String errcode) {
            this.errcode = errcode;
        }

        @Generated
        public void setErrmsg(String errmsg) {
            this.errmsg = errmsg;
        }

        @Generated
        public Message() {
        }

        @Generated
        public Message(String errcode, String errmsg) {
            this.errcode = errcode;
            this.errmsg = errmsg;
        }

        @Generated
        public static class MessageBuilder {
            @Generated
            private String errcode;
            @Generated
            private String errmsg;

            @Generated
            MessageBuilder() {
            }

            @Generated
            public MessageBuilder errcode(String errcode) {
                this.errcode = errcode;
                return this;
            }

            @Generated
            public MessageBuilder errmsg(String errmsg) {
                this.errmsg = errmsg;
                return this;
            }

            @Generated
            public Message build() {
                return new Message(this.errcode, this.errmsg);
            }

            @Generated
            public String toString() {
                return "ErrorsHandler.Message.MessageBuilder(errcode=" + this.errcode + ", errmsg=" + this.errmsg + ")";
            }
        }
    }
}

