/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.vortex.handler;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.miaixz.bus.core.lang.exception.ValidateException;
import org.miaixz.bus.core.net.Protocol;
import org.miaixz.bus.vortex.Assets;
import org.miaixz.bus.vortex.Context;
import org.miaixz.bus.vortex.Format;
import org.miaixz.bus.vortex.Handler;
import org.miaixz.bus.vortex.Router;
import org.miaixz.bus.vortex.handler.AccessHandler;
import org.miaixz.bus.vortex.magic.ErrorCode;
import org.miaixz.bus.vortex.support.HttpRequestRouter;
import org.miaixz.bus.vortex.support.McpRequestRouter;
import org.miaixz.bus.vortex.support.MqRequestRouter;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import reactor.util.annotation.NonNull;

public class VortexHandler {
    private final Map<String, Router> strategies = new ConcurrentHashMap<String, Router>();
    private final Router defaultRouter;
    private final List<Handler> handlers;

    public VortexHandler(List<Handler> handlers) {
        this.strategies.put(Protocol.HTTP.name, new HttpRequestRouter());
        this.strategies.put(Protocol.MQ.name, new MqRequestRouter());
        this.strategies.put(Protocol.MCP.name, new McpRequestRouter());
        this.defaultRouter = this.strategies.get(Protocol.HTTP.name);
        Objects.requireNonNull(this.defaultRouter, "Default strategy cannot be null");
        this.handlers = handlers.isEmpty() ? List.of(new AccessHandler()) : handlers.stream().sorted(Comparator.comparingInt(Handler::getOrder)).collect(Collectors.toList());
    }

    @NonNull
    public Mono<ServerResponse> handle(ServerRequest request) {
        return Mono.defer(() -> {
            Context context = Context.get(request);
            if (context == null) {
                Format.error(null, "CONTEXT_NULL", "Request context is null for path: " + request.path());
                throw new ValidateException(ErrorCode._116000);
            }
            ServerWebExchange exchange = request.exchange();
            Format.requestStart(exchange);
            Assets assets = context.getAssets();
            if (assets == null) {
                Format.error(exchange, "ASSETS_NULL", "Assets is null in request context");
                throw new ValidateException(ErrorCode._100800);
            }
            String mode = switch (assets.getMode()) {
                case 1 -> Protocol.HTTP.name();
                case 2 -> Protocol.MQ.name();
                case 3 -> Protocol.MCP.name();
                default -> Protocol.HTTP.name();
            };
            Router router = this.strategies.getOrDefault(mode, this.defaultRouter);
            Format.info(exchange, "STRATEGY_SELECTED", "Using route strategy: " + router.getClass().getSimpleName());
            return this.executePreHandle(exchange, router).flatMap(preHandleResult -> {
                if (!preHandleResult.booleanValue()) {
                    throw new ValidateException(ErrorCode._100800);
                }
                return router.route(request, context, assets).flatMap(response -> this.executePostHandlers(exchange, router, (ServerResponse)response)).doOnSuccess(response -> {
                    long duration = System.currentTimeMillis() - context.getTimestamp();
                    Format.info(exchange, "REQUEST_DURATION", "Method: " + assets.getMethod() + ", Duration: " + duration + "ms");
                }).onErrorResume(error -> {
                    Format.error(exchange, "REQUEST_ERROR", "Error processing request: " + error.getMessage());
                    return Mono.whenDelayError((Iterable)this.handlers.stream().map(handler -> handler.afterCompletion(exchange, router, null, null, (Throwable)error)).collect(Collectors.toList())).then(Mono.error((Throwable)error));
                });
            });
        }).doOnSuccess(response -> Format.requestEnd(request.exchange(), response.statusCode().value()));
    }

    private Mono<Boolean> executePreHandle(ServerWebExchange exchange, Router router) {
        return Mono.zip((Iterable)this.handlers.stream().map(handler -> handler.preHandle(exchange, router, null)).collect(Collectors.toList()), results -> {
            boolean bl;
            if (((Object[])results).length > 0) {
                if (Arrays.stream(results).allMatch(Boolean.class::cast)) {
                    bl = true;
                    return bl;
                }
            }
            bl = false;
            return bl;
        });
    }

    private Mono<ServerResponse> executePostHandlers(ServerWebExchange exchange, Router router, ServerResponse response) {
        return Mono.whenDelayError((Iterable)this.handlers.stream().map(handler -> handler.postHandle(exchange, router, null, response)).collect(Collectors.toList())).thenReturn((Object)response).flatMap(res -> Mono.whenDelayError((Iterable)this.handlers.stream().map(handler -> handler.afterCompletion(exchange, router, null, res, null)).collect(Collectors.toList())).thenReturn(res));
    }
}

