/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.bean;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.SequencedSet;
import org.microbean.bean.Assignment;
import org.microbean.bean.AttributedElement;
import org.microbean.bean.Request;

public interface Aggregate {
    public static final SequencedSet<Assignment<?>> EMPTY_ASSIGNMENTS = Collections.unmodifiableSequencedSet(new LinkedHashSet(0));
    public static final SequencedSet<AttributedElement> EMPTY_DEPENDENCIES = Collections.unmodifiableSequencedSet(new LinkedHashSet(0));

    default public SequencedSet<AttributedElement> dependencies() {
        return EMPTY_DEPENDENCIES;
    }

    default public SequencedSet<? extends Assignment<?>> assign(Request<?> r) {
        SequencedSet<AttributedElement> ds = this.dependencies();
        if (ds == null || ds.isEmpty()) {
            return EMPTY_ASSIGNMENTS;
        }
        LinkedHashSet assignments = new LinkedHashSet();
        for (AttributedElement d : ds) {
            assignments.add(new Assignment(d, r.reference(d.attributedType())));
        }
        return Collections.unmodifiableSequencedSet(assignments);
    }
}

