/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.bean;

import java.lang.constant.ClassDesc;
import java.lang.constant.Constable;
import java.lang.constant.ConstantDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.DynamicConstantDesc;
import java.lang.constant.MethodHandleDesc;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import org.microbean.lang.TypeAndElementSource;

public final class BeanTypes
implements Constable {
    private static final System.Logger LOGGER = System.getLogger(BeanTypes.class.getName());
    private final Map<TypeMirror, List<TypeMirror>> beanTypesCache;
    private final Comparator<TypeMirror> c;
    private final TypeAndElementSource tes;

    public BeanTypes(TypeAndElementSource tes) {
        this.tes = Objects.requireNonNull(tes, "tes");
        this.c = new SpecializationComparator();
        this.beanTypesCache = new ConcurrentHashMap<TypeMirror, List<TypeMirror>>();
    }

    @Override
    public final Optional<? extends ConstantDesc> describeConstable() {
        Optional<ConstantDesc> optional;
        TypeAndElementSource typeAndElementSource = this.tes;
        if (typeAndElementSource instanceof Constable) {
            Constable c = (Constable)typeAndElementSource;
            optional = c.describeConstable();
        } else {
            optional = Optional.empty();
        }
        return optional.map(tesDesc -> DynamicConstantDesc.of(ConstantDescs.BSM_INVOKE, MethodHandleDesc.ofConstructor(ClassDesc.of(this.getClass().getName()), org.microbean.lang.ConstantDescs.CD_TypeAndElementSource), tesDesc));
    }

    public final void clearCaches() {
        this.beanTypesCache.clear();
    }

    public final List<TypeMirror> beanTypes(TypeMirror t) {
        return switch (t.getKind()) {
            case TypeKind.ARRAY -> this.beanTypesCache.computeIfAbsent(t, t0 -> BeanTypes.legalBeanType(t0) ? List.of(t0, this.tes.declaredType((CharSequence)"java.lang.Object")) : List.of());
            case TypeKind.BOOLEAN, TypeKind.BYTE, TypeKind.CHAR, TypeKind.DOUBLE, TypeKind.FLOAT, TypeKind.INT, TypeKind.LONG, TypeKind.SHORT -> this.beanTypesCache.computeIfAbsent(t, t0 -> List.of(t0, this.tes.declaredType((CharSequence)"java.lang.Object")));
            case TypeKind.DECLARED, TypeKind.TYPEVAR -> this.beanTypesCache.computeIfAbsent(t, t0 -> this.supertypes((TypeMirror)t0, BeanTypes::legalBeanType));
            default -> {
                if (!$assertionsDisabled && BeanTypes.legalBeanType(t)) {
                    throw new AssertionError();
                }
                yield List.of();
            }
        };
    }

    final List<TypeMirror> supertypes(TypeMirror t) {
        return this.supertypes(t, BeanTypes::returnTrue);
    }

    private final List<TypeMirror> supertypes(TypeMirror t, Predicate<? super TypeMirror> p) {
        ArrayList nonInterfaceTypes = new ArrayList(7);
        ArrayList interfaceTypes = new ArrayList(17);
        this.supertypes(t, p, nonInterfaceTypes, interfaceTypes, HashSet.newHashSet(13));
        nonInterfaceTypes.trimToSize();
        interfaceTypes.trimToSize();
        return Stream.concat(nonInterfaceTypes.stream(), interfaceTypes.stream().sorted(this.c)).toList();
    }

    private final void supertypes(TypeMirror t, Predicate<? super TypeMirror> p, ArrayList<? super TypeMirror> nonInterfaceTypes, ArrayList<? super TypeMirror> interfaceTypes, Set<? super String> seen) {
        if (seen.add(BeanTypes.name(t))) {
            if (p.test(t)) {
                if (BeanTypes.isInterface(t)) {
                    interfaceTypes.add(t);
                } else {
                    nonInterfaceTypes.add(t);
                }
            }
            for (TypeMirror directSupertype : this.tes.directSupertypes(t)) {
                this.supertypes(directSupertype, p, nonInterfaceTypes, interfaceTypes, seen);
            }
        }
    }

    public static final boolean legalBeanType(TypeMirror t) {
        return switch (t.getKind()) {
            case TypeKind.ARRAY -> {
                if (!BeanTypes.legalBeanType(((ArrayType)t).getComponentType())) {
                    if (LOGGER.isLoggable(System.Logger.Level.WARNING)) {
                        LOGGER.log(System.Logger.Level.WARNING, String.valueOf(t) + " has a component type that is an illegal bean type (" + String.valueOf(((ArrayType)t).getComponentType()) + ")");
                    }
                    yield false;
                }
                yield true;
            }
            case TypeKind.BOOLEAN, TypeKind.BYTE, TypeKind.CHAR, TypeKind.DOUBLE, TypeKind.FLOAT, TypeKind.INT, TypeKind.LONG, TypeKind.SHORT -> true;
            case TypeKind.DECLARED -> {
                for (TypeMirror var2_2 : ((DeclaredType)t).getTypeArguments()) {
                    if (var2_2.getKind() == TypeKind.TYPEVAR || BeanTypes.legalBeanType(var2_2)) continue;
                    if (LOGGER.isLoggable(System.Logger.Level.WARNING)) {
                        LOGGER.log(System.Logger.Level.WARNING, String.valueOf(t) + " has a type argument that is an illegal bean type (" + String.valueOf(var2_2) + ")");
                    }
                    yield false;
                }
                yield true;
            }
            default -> {
                if (LOGGER.isLoggable(System.Logger.Level.WARNING)) {
                    LOGGER.log(System.Logger.Level.WARNING, String.valueOf(t) + " is an illegal bean type");
                }
                yield false;
            }
        };
    }

    static final String name(TypeMirror t) {
        return switch (t.getKind()) {
            case TypeKind.ARRAY -> BeanTypes.name(((ArrayType)t).getComponentType()) + "[]";
            case TypeKind.BOOLEAN -> "boolean";
            case TypeKind.BYTE -> "byte";
            case TypeKind.CHAR -> "char";
            case TypeKind.DECLARED -> BeanTypes.name(((DeclaredType)t).asElement());
            case TypeKind.DOUBLE -> "double";
            case TypeKind.FLOAT -> "float";
            case TypeKind.INT -> "int";
            case TypeKind.INTERSECTION -> {
                StringJoiner sj = new StringJoiner("&");
                for (TypeMirror var3_3 : ((IntersectionType)t).getBounds()) {
                    sj.add(BeanTypes.name(var3_3));
                }
                yield sj.toString();
            }
            case TypeKind.LONG -> "long";
            case TypeKind.SHORT -> "short";
            case TypeKind.TYPEVAR -> BeanTypes.name(((TypeVariable)t).asElement());
            default -> t.toString();
        };
    }

    static final String name(Element e) {
        String string;
        if (e instanceof QualifiedNameable) {
            QualifiedNameable qn = (QualifiedNameable)e;
            string = BeanTypes.name(qn);
        } else {
            string = BeanTypes.name(e.getSimpleName());
        }
        return string;
    }

    private static final String name(QualifiedNameable qn) {
        Name n = qn.getQualifiedName();
        return n == null || n.isEmpty() ? BeanTypes.name(qn.getSimpleName()) : BeanTypes.name(n);
    }

    private static final String name(CharSequence cs) {
        String s;
        return cs instanceof String ? (s = (String)cs) : cs.toString();
    }

    private static final boolean isInterface(TypeMirror t) {
        return t.getKind() == TypeKind.DECLARED && BeanTypes.isInterface(((DeclaredType)t).asElement());
    }

    private static final boolean isInterface(Element e) {
        return e.getKind().isInterface();
    }

    private static final <T> boolean returnTrue(T ignored) {
        return true;
    }

    private final class SpecializationComparator
    implements Comparator<TypeMirror> {
        private SpecializationComparator() {
        }

        @Override
        public final int compare(TypeMirror t, TypeMirror s) {
            if (t == s) {
                return 0;
            }
            if (t == null) {
                return 1;
            }
            if (s == null) {
                return -1;
            }
            if (BeanTypes.this.tes.sameType(t, s)) {
                return 0;
            }
            if (BeanTypes.this.tes.subtype(t, s)) {
                return -1;
            }
            if (BeanTypes.this.tes.subtype(s, t)) {
                return 1;
            }
            return BeanTypes.name(t).compareTo(BeanTypes.name(s));
        }
    }
}

