/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.bean;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.microbean.bean.AutoCloseableRegistry;
import org.microbean.bean.BeanException;

public class DefaultAutoCloseableRegistry
implements AutoCloseableRegistry {
    private final Lock lock = new ReentrantLock();
    private Set<AutoCloseable> closeables;

    @Override
    public DefaultAutoCloseableRegistry newChild() {
        DefaultAutoCloseableRegistry child = new DefaultAutoCloseableRegistry();
        if (!this.register(child)) {
            throw new IllegalStateException();
        }
        return child;
    }

    @Override
    public void close() {
        Set<AutoCloseable> closeables;
        this.lock.lock();
        try {
            closeables = this.closeables;
            if (closeables == Set.of()) {
                return;
            }
            this.closeables = Set.of();
        }
        finally {
            this.lock.unlock();
        }
        if (closeables == null) {
            return;
        }
        RuntimeException re = null;
        for (AutoCloseable c : closeables) {
            try {
                c.close();
            }
            catch (RuntimeException e) {
                if (re == null) {
                    re = e;
                    continue;
                }
                re.addSuppressed(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                if (re == null) {
                    re = new BeanException(e.getMessage(), e);
                    continue;
                }
                re.addSuppressed(e);
            }
            catch (Exception e) {
                if (re == null) {
                    re = new BeanException(e.getMessage(), e);
                    continue;
                }
                re.addSuppressed(e);
            }
        }
        if (re != null) {
            throw re;
        }
    }

    @Override
    public final boolean closed() {
        this.lock.lock();
        try {
            boolean bl = this.closeables == Set.of();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public final boolean register(AutoCloseable closeable) {
        if (closeable == null || closeable == this) {
            return false;
        }
        this.lock.lock();
        try {
            if (this.closeables == Set.of()) {
                boolean bl = false;
                return bl;
            }
            if (this.closeables == null) {
                this.closeables = new LinkedHashSet<AutoCloseable>();
            }
            boolean bl = this.closeables.add(closeable);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }
}

