/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.bean;

import java.lang.constant.ClassDesc;
import java.lang.constant.Constable;
import java.lang.constant.ConstantDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.DynamicConstantDesc;
import java.lang.constant.MethodHandleDesc;
import java.util.Optional;
import org.microbean.bean.Aggregate;
import org.microbean.bean.DestructionException;
import org.microbean.bean.Request;

@FunctionalInterface
public interface Factory<I>
extends Aggregate,
Constable {
    public I create(Request<I> var1);

    default public I singleton() {
        return null;
    }

    default public boolean destroys() {
        return true;
    }

    default public void destroy(I i, Request<I> creationRequest) {
        if (i instanceof AutoCloseable) {
            AutoCloseable ac = (AutoCloseable)i;
            try {
                ac.close();
            }
            catch (Error | RuntimeException re) {
                throw re;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new DestructionException(e.getMessage(), e);
            }
            catch (Exception e) {
                throw new DestructionException(e.getMessage(), e);
            }
        }
    }

    @Override
    default public Optional<? extends ConstantDesc> describeConstable() {
        return this.getClass().describeConstable().map(classDesc -> DynamicConstantDesc.of(ConstantDescs.BSM_INVOKE, MethodHandleDesc.ofConstructor(classDesc, new ClassDesc[0])));
    }
}

