/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.bean;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.SequencedSet;
import org.microbean.bean.Assignment;
import org.microbean.bean.AttributedElement;
import org.microbean.bean.Producer;
import org.microbean.bean.Request;
import org.microbean.interceptor.InterceptionFunction;
import org.microbean.interceptor.Interceptions;
import org.microbean.interceptor.InterceptorMethod;

public final class InterceptingProducer<I>
implements Producer<I> {
    private final InterceptionFunction f;
    private final Producer<I> producer;

    public InterceptingProducer(Collection<? extends InterceptorMethod> interceptorMethods, Producer<I> producer) {
        this.producer = Objects.requireNonNull(producer, "producer");
        SequencedSet<AttributedElement> dependencies = producer.dependencies();
        this.f = Interceptions.ofConstruction(interceptorMethods, (ignored, argumentsArray) -> {
            LinkedHashSet<Assignment<Object>> assignments = new LinkedHashSet<Assignment<Object>>();
            int i = 0;
            for (AttributedElement dependency : dependencies) {
                assignments.add(new Assignment<Object>(dependency, argumentsArray[i++]));
            }
            return this.produce(Collections.unmodifiableSequencedSet(assignments));
        });
    }

    @Override
    public final SequencedSet<? extends Assignment<?>> assign(Request<?> r) {
        return this.producer.assign(r);
    }

    @Override
    public final SequencedSet<AttributedElement> dependencies() {
        return this.producer.dependencies();
    }

    @Override
    public final void dispose(I i, Request<I> r) {
        this.producer.dispose(i, r);
    }

    @Override
    public final I produce(Request<?> r) {
        SequencedSet<AttributedElement> dependencies = this.dependencies();
        Object[] array = new Object[dependencies.size()];
        int i = 0;
        for (AttributedElement d : dependencies) {
            array[i++] = r.reference(d.attributedType());
        }
        return (I)this.f.apply(array);
    }

    @Override
    public final I produce(SequencedSet<? extends Assignment<?>> assignments) {
        return this.producer.produce(assignments);
    }
}

