/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.bean;

import java.util.SequencedSet;
import org.microbean.bean.Aggregate;
import org.microbean.bean.Assignment;
import org.microbean.bean.DestructionException;
import org.microbean.bean.Request;

@FunctionalInterface
public interface Producer<I>
extends Aggregate {
    default public void dispose(I i, Request<I> r) {
        if (i instanceof AutoCloseable) {
            AutoCloseable ac = (AutoCloseable)i;
            try {
                ac.close();
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new DestructionException(e.getMessage(), e);
            }
            catch (Exception e) {
                throw new DestructionException(e.getMessage(), e);
            }
        }
    }

    default public I produce(Request<?> r) {
        return this.produce(this.assign(r));
    }

    public I produce(SequencedSet<? extends Assignment<?>> var1);
}

