/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.bean;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.microbean.qualifier.NamedAttributeMap;

public final class Qualifiers {
    private static final NamedAttributeMap<String> QUALIFIER = new NamedAttributeMap("Qualifier");
    private static final List<NamedAttributeMap<String>> QUALIFIER_LIST = List.of(QUALIFIER);
    private static final NamedAttributeMap<?> ANY_QUALIFIER = new NamedAttributeMap("Any", Map.of(), Map.of(), QUALIFIER_LIST);
    private static final List<NamedAttributeMap<?>> ANY_QUALIFIERS = List.of(ANY_QUALIFIER);
    private static final NamedAttributeMap<?> DEFAULT_QUALIFIER = new NamedAttributeMap("Default", Map.of(), Map.of(), QUALIFIER_LIST);
    private static final List<NamedAttributeMap<?>> DEFAULT_QUALIFIERS = List.of(DEFAULT_QUALIFIER);
    private static final List<NamedAttributeMap<?>> ANY_AND_DEFAULT_QUALIFIERS = List.of(ANY_QUALIFIER, DEFAULT_QUALIFIER);

    private Qualifiers() {
    }

    public static final NamedAttributeMap<?> anyQualifier() {
        return ANY_QUALIFIER;
    }

    public static final boolean anyQualifier(NamedAttributeMap<?> nam) {
        return ANY_QUALIFIER.equals(nam) && Qualifiers.qualifier(nam);
    }

    public static final List<NamedAttributeMap<?>> anyQualifiers() {
        return ANY_QUALIFIERS;
    }

    public static final List<NamedAttributeMap<?>> anyAndDefaultQualifiers() {
        return ANY_AND_DEFAULT_QUALIFIERS;
    }

    public static final NamedAttributeMap<?> defaultQualifier() {
        return DEFAULT_QUALIFIER;
    }

    public static final boolean defaultQualifier(NamedAttributeMap<?> nam) {
        return DEFAULT_QUALIFIER.equals(nam) && Qualifiers.qualifier(nam);
    }

    public static final List<NamedAttributeMap<?>> defaultQualifiers() {
        return DEFAULT_QUALIFIERS;
    }

    public static final NamedAttributeMap<?> qualifier() {
        return QUALIFIER;
    }

    public static final boolean qualifier(NamedAttributeMap<?> q) {
        return q != null && Qualifiers.qualifier(q.metadata());
    }

    private static final boolean qualifier(Iterable<? extends NamedAttributeMap<?>> mds) {
        for (NamedAttributeMap<?> md : mds) {
            if ((!QUALIFIER.equals(md) || !md.metadata().isEmpty()) && !Qualifiers.qualifier(md)) continue;
            return true;
        }
        return false;
    }

    public static final List<NamedAttributeMap<?>> qualifiers(Collection<? extends NamedAttributeMap<?>> c) {
        if (c == null || c.isEmpty()) {
            return List.of();
        }
        ArrayList list = new ArrayList(c.size());
        for (NamedAttributeMap<?> a : c) {
            if (!Qualifiers.qualifier(a)) continue;
            list.add(a);
        }
        list.trimToSize();
        return Collections.unmodifiableList(list);
    }

    public static final NamedAttributeMap<?> of(NamedAttributeMap<?> nam) {
        NamedAttributeMap<?> namedAttributeMap;
        NamedAttributeMap<?> namedAttributeMap2 = nam;
        int n = 0;
        block6: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NamedAttributeMap.class, NamedAttributeMap.class, NamedAttributeMap.class}, namedAttributeMap2, n)) {
                case -1: {
                    throw new NullPointerException("nam");
                }
                case 0: {
                    NamedAttributeMap<?> q = namedAttributeMap2;
                    if (!Qualifiers.anyQualifier(q)) {
                        n = 1;
                        continue block6;
                    }
                    namedAttributeMap = Qualifiers.anyQualifier();
                    break block6;
                }
                case 1: {
                    NamedAttributeMap<?> q = namedAttributeMap2;
                    if (!Qualifiers.defaultQualifier(q)) {
                        n = 2;
                        continue block6;
                    }
                    namedAttributeMap = Qualifiers.defaultQualifier();
                    break block6;
                }
                case 2: {
                    NamedAttributeMap<?> q = namedAttributeMap2;
                    if (!QUALIFIER.equals(q) || !q.metadata().isEmpty()) {
                        n = 3;
                        continue block6;
                    }
                    namedAttributeMap = Qualifiers.qualifier();
                    break block6;
                }
                default: {
                    namedAttributeMap = nam;
                    break block6;
                }
            }
            break;
        }
        return namedAttributeMap;
    }

    public static final List<NamedAttributeMap<?>> of(List<NamedAttributeMap<?>> list) {
        List<NamedAttributeMap<?>> list2;
        List<NamedAttributeMap<?>> list3 = list;
        int n = 0;
        block6: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{List.class, List.class, List.class}, list3, n)) {
                case -1: {
                    throw new NullPointerException("list");
                }
                case 0: {
                    List<NamedAttributeMap<?>> l = list3;
                    if (l.size() != 1 || !Qualifiers.anyQualifier(l.get(0))) {
                        n = 1;
                        continue block6;
                    }
                    list2 = Qualifiers.anyQualifiers();
                    break block6;
                }
                case 1: {
                    List<NamedAttributeMap<?>> l = list3;
                    if (l.size() != 1 || !Qualifiers.defaultQualifier(l.get(0))) {
                        n = 2;
                        continue block6;
                    }
                    list2 = Qualifiers.defaultQualifiers();
                    break block6;
                }
                case 2: {
                    List<NamedAttributeMap<?>> l = list3;
                    if (l.size() != 2 || !Qualifiers.anyQualifier(l.get(0)) || !Qualifiers.defaultQualifier(l.get(1))) {
                        n = 3;
                        continue block6;
                    }
                    list2 = Qualifiers.anyAndDefaultQualifiers();
                    break block6;
                }
                default: {
                    list2 = list;
                    break block6;
                }
            }
            break;
        }
        return list2;
    }
}

