/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.bean;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.microbean.bean.Matcher;
import org.microbean.bean.Qualifiers;
import org.microbean.qualifier.NamedAttributeMap;

public final class QualifiersMatcher
implements Matcher<Collection<? extends NamedAttributeMap<?>>, Collection<? extends NamedAttributeMap<?>>> {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final boolean test(Collection<? extends NamedAttributeMap<?>> receiverAttributes, Collection<? extends NamedAttributeMap<?>> payloadAttributes) {
        NamedAttributeMap namedAttributeMap;
        List<NamedAttributeMap<?>> receiverQualifiers = Qualifiers.qualifiers(receiverAttributes);
        List<NamedAttributeMap<?>> payloadQualifiers = Qualifiers.qualifiers(payloadAttributes);
        if (receiverQualifiers.isEmpty()) {
            if (payloadQualifiers.isEmpty()) return true;
            if (!QualifiersMatcher.containsAllMatching(payloadQualifiers::contains, Qualifiers.defaultQualifiers())) return false;
            return true;
        }
        if (!payloadQualifiers.isEmpty()) return QualifiersMatcher.containsAllMatching(payloadQualifiers::contains, receiverQualifiers);
        Iterator iterator = receiverQualifiers.iterator();
        do {
            if (!iterator.hasNext()) return false;
            namedAttributeMap = (NamedAttributeMap)iterator.next();
            if (Qualifiers.anyQualifier(namedAttributeMap)) return true;
        } while (!Qualifiers.defaultQualifier(namedAttributeMap));
        return true;
    }

    private static final boolean containsAllMatching(Predicate<? super Object> p, Iterable<?> i) {
        for (Object o : i) {
            if (p.test(o)) continue;
            return false;
        }
        return true;
    }
}

