/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.bean;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import org.microbean.bean.Ranked;
import org.microbean.bean.Reducer;

public final class RankedReducer<C, T extends Ranked>
implements Reducer<C, T> {
    private static final RankedReducer<?, ?> INSTANCE = new RankedReducer();

    private RankedReducer() {
    }

    @Override
    public final T reduce(List<? extends T> elements, C c, BiFunction<? super List<? extends T>, ? super C, ? extends T> failureHandler) {
        if (elements == null || elements.isEmpty()) {
            return null;
        }
        if (elements.size() == 1) {
            return (T)((Ranked)elements.get(0));
        }
        Ranked candidate = null;
        ArrayList<Ranked> unresolved = null;
        int maxRank = 0;
        for (Ranked element : elements) {
            if (element.alternate()) {
                int elementRank = element.rank();
                if (elementRank == maxRank) {
                    if (candidate == null || !candidate.alternate()) {
                        candidate = element;
                        continue;
                    }
                    assert (candidate.rank() == maxRank) : "Unexpected rank: " + candidate.rank() + "; was expecting: " + maxRank;
                    if (unresolved == null) {
                        unresolved = new ArrayList(6);
                    }
                    unresolved.add(candidate);
                    unresolved.add(element);
                    candidate = null;
                    continue;
                }
                if (elementRank <= maxRank) continue;
                if (candidate == null || !candidate.alternate() || elementRank > candidate.rank()) {
                    candidate = element;
                    maxRank = elementRank;
                    continue;
                }
                if (elementRank == candidate.rank()) {
                    if (unresolved == null) {
                        unresolved = new ArrayList(6);
                    }
                    unresolved.add(candidate);
                    unresolved.add(element);
                    candidate = null;
                    continue;
                }
                assert (elementRank < candidate.rank()) : "elementRank >= candidate.rank(): " + elementRank + " >= " + candidate.rank();
                continue;
            }
            if (candidate == null) {
                candidate = element;
                continue;
            }
            if (candidate.alternate()) continue;
            if (unresolved == null) {
                unresolved = new ArrayList<Ranked>(6);
            }
            unresolved.add(candidate);
            unresolved.add(element);
            candidate = null;
        }
        if (unresolved != null && !unresolved.isEmpty()) {
            if (candidate != null) {
                unresolved.add(candidate);
            }
            candidate = failureHandler == null ? (Ranked)Reducer.fail(Collections.unmodifiableList(unresolved), c) : (Ranked)failureHandler.apply(Collections.unmodifiableList(unresolved), c);
        }
        return (T)candidate;
    }

    public static final <C, T extends Ranked> Reducer<C, T> of() {
        return INSTANCE;
    }
}

