/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.bean;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import org.microbean.bean.AmbiguousReductionException;
import org.microbean.bean.Selectable;
import org.microbean.bean.UnsatisfiedReductionException;

@FunctionalInterface
public interface Reducer<C, T> {
    public T reduce(List<? extends T> var1, C var2, BiFunction<? super List<? extends T>, ? super C, ? extends T> var3);

    default public T reduce(Selectable<? super C, ? extends T> f, C c, BiFunction<? super List<? extends T>, ? super C, ? extends T> failureHandler) {
        return this.reduce(f.select(c), c, failureHandler);
    }

    default public T reduce(Selectable<? super C, ? extends T> f, C c) {
        return (T)this.reduce(f.select(c), c, Reducer::fail);
    }

    default public T reduce(List<? extends T> elements, C c) {
        return (T)this.reduce(elements, c, Reducer::fail);
    }

    default public Reducer<C, T> cached() {
        ConcurrentHashMap cache = new ConcurrentHashMap();
        return (l, c, fh) -> {
            record Key<C, T>(List<T> l, C c) {
            }
            return cache.computeIfAbsent(new Key(List.copyOf(l), c), k -> this.reduce(k.l(), k.c(), fh));
        };
    }

    public static <C, T> Reducer<C, T> ofSimple() {
        return Reducer::reduceObviously;
    }

    public static <C, T> Reducer<C, T> ofFailing() {
        return Reducer::failUnconditionally;
    }

    public static <C, T> T fail(List<? extends T> elements, C c) {
        if (elements.isEmpty()) {
            throw new UnsatisfiedReductionException(c);
        }
        if (elements.size() > 1) {
            throw new AmbiguousReductionException(c, elements, "Cannot reduce: " + String.valueOf(elements));
        }
        return elements.get(0);
    }

    public static <A, B, C> C returnNull(A a, B b) {
        return null;
    }

    private static <C, T> T reduceObviously(List<? extends T> l, C c, BiFunction<? super List<? extends T>, ? super C, ? extends T> fh) {
        return l.isEmpty() ? null : (l.size() == 1 ? (T)l.get(0) : (T)fh.apply((List<? extends T>)l, (C)c));
    }

    private static <C, T> T failUnconditionally(List<? extends T> l, C c, BiFunction<? super List<? extends T>, ? super C, ? extends T> fh) {
        return fh.apply(l, c);
    }
}

