/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.bean;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.microbean.bean.Reducer;
import org.microbean.bean.Selectable;

@FunctionalInterface
public interface Reducible<C, T> {
    public T reduce(C var1);

    public static <C, E> Reducible<C, E> of(Selectable<C, E> selectable, Reducer<C, E> r) {
        return Reducible.of(selectable, r, Reducer::fail);
    }

    public static <C, E> Reducible<C, E> of(Selectable<C, E> selectable, Reducer<C, E> r, BiFunction<? super List<? extends E>, ? super C, ? extends E> failureHandler) {
        Objects.requireNonNull(selectable, "selectable");
        Objects.requireNonNull(r, "r");
        BiFunction fh = Objects.requireNonNull(failureHandler, "failureHandler");
        return c -> r.reduce(selectable.select(c), c, fh);
    }

    public static <C, E> Reducible<C, E> ofCaching(Selectable<C, E> selectable, Reducer<C, E> r) {
        return Reducible.ofCaching(selectable, r, Reducer::fail);
    }

    public static <C, E> Reducible<C, E> ofCaching(Selectable<C, E> selectable, Reducer<C, E> r, BiFunction<? super List<? extends E>, ? super C, ? extends E> failureHandler) {
        return Reducible.ofCaching(selectable, r, failureHandler, new ConcurrentHashMap()::computeIfAbsent);
    }

    public static <C, E> Reducible<C, E> ofCaching(Selectable<C, E> selectable, Reducer<C, E> r, BiFunction<? super List<? extends E>, ? super C, ? extends E> failureHandler, BiFunction<? super C, Function<C, E>, ? extends E> computeIfAbsent) {
        Reducible rd = Reducible.of(selectable, r, failureHandler);
        return c -> computeIfAbsent.apply((Object)c, rd::reduce);
    }
}

