/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.bean;

import java.lang.constant.ClassDesc;
import java.lang.constant.Constable;
import java.lang.constant.ConstantDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.DynamicConstantDesc;
import java.lang.constant.MethodHandleDesc;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Parameterizable;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.ReferenceType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import org.microbean.bean.Matcher;
import org.microbean.lang.TypeAndElementSource;

public final class TypeMatcher
implements Constable,
Matcher<TypeMirror, TypeMirror> {
    private static final System.Logger LOGGER = System.getLogger(TypeMatcher.class.getName());
    private final TypeAndElementSource tes;

    public TypeMatcher(TypeAndElementSource tes) {
        this.tes = Objects.requireNonNull(tes, "tes");
    }

    @Override
    public final Optional<? extends ConstantDesc> describeConstable() {
        Optional<ConstantDesc> optional;
        TypeAndElementSource typeAndElementSource = this.tes;
        if (typeAndElementSource instanceof Constable) {
            Constable c = (Constable)typeAndElementSource;
            optional = c.describeConstable();
        } else {
            optional = Optional.empty();
        }
        return optional.map(tesDesc -> DynamicConstantDesc.of(ConstantDescs.BSM_INVOKE, MethodHandleDesc.ofConstructor(ClassDesc.of(this.getClass().getName()), org.microbean.lang.ConstantDescs.CD_TypeAndElementSource), tesDesc));
    }

    @Override
    public final boolean test(TypeMirror receiver, TypeMirror payload) {
        boolean bl;
        block43: {
            block42: {
                block41: {
                    if (receiver == Objects.requireNonNull(payload, "payload")) break block41;
                    block0 : switch (receiver.getKind()) {
                        case BOOLEAN: {
                            if (payload.getKind() == TypeKind.BOOLEAN || TypeMatcher.declaredTypeNamed(payload, "java.lang.Boolean")) {
                                break;
                            }
                            break block42;
                        }
                        case BYTE: {
                            if (payload.getKind() == TypeKind.BYTE || TypeMatcher.declaredTypeNamed(payload, "java.lang.Byte")) {
                                break;
                            }
                            break block42;
                        }
                        case CHAR: {
                            if (payload.getKind() == TypeKind.CHAR || TypeMatcher.declaredTypeNamed(payload, "java.lang.Character")) {
                                break;
                            }
                            break block42;
                        }
                        case DOUBLE: {
                            if (payload.getKind() == TypeKind.DOUBLE || TypeMatcher.declaredTypeNamed(payload, "java.lang.Double")) {
                                break;
                            }
                            break block42;
                        }
                        case FLOAT: {
                            if (payload.getKind() == TypeKind.FLOAT || TypeMatcher.declaredTypeNamed(payload, "java.lang.Float")) {
                                break;
                            }
                            break block42;
                        }
                        case INT: {
                            if (payload.getKind() == TypeKind.INT || TypeMatcher.declaredTypeNamed(payload, "java.lang.Integer")) {
                                break;
                            }
                            break block42;
                        }
                        case LONG: {
                            if (payload.getKind() == TypeKind.LONG || TypeMatcher.declaredTypeNamed(payload, "java.lang.Long")) {
                                break;
                            }
                            break block42;
                        }
                        case SHORT: {
                            if (payload.getKind() == TypeKind.SHORT || TypeMatcher.declaredTypeNamed(payload, "java.lang.Short")) {
                                break;
                            }
                            break block42;
                        }
                        case ARRAY: {
                            if (payload.getKind() == TypeKind.ARRAY && this.identical(TypeMatcher.elementType(receiver), TypeMatcher.elementType(payload))) {
                                break;
                            }
                            break block42;
                        }
                        case DECLARED: {
                            switch (payload.getKind()) {
                                case BOOLEAN: {
                                    if (TypeMatcher.named((DeclaredType)receiver, "java.lang.Boolean")) {
                                        break block0;
                                    }
                                    break block42;
                                }
                                case BYTE: {
                                    if (TypeMatcher.named((DeclaredType)receiver, "java.lang.Byte")) {
                                        break block0;
                                    }
                                    break block42;
                                }
                                case CHAR: {
                                    if (TypeMatcher.named((DeclaredType)receiver, "java.lang.Character")) {
                                        break block0;
                                    }
                                    break block42;
                                }
                                case DOUBLE: {
                                    if (TypeMatcher.named((DeclaredType)receiver, "java.lang.Double")) {
                                        break block0;
                                    }
                                    break block42;
                                }
                                case FLOAT: {
                                    if (TypeMatcher.named((DeclaredType)receiver, "java.lang.Float")) {
                                        break block0;
                                    }
                                    break block42;
                                }
                                case INT: {
                                    if (TypeMatcher.named((DeclaredType)receiver, "java.lang.Integer")) {
                                        break block0;
                                    }
                                    break block42;
                                }
                                case LONG: {
                                    if (TypeMatcher.named((DeclaredType)receiver, "java.lang.Long")) {
                                        break block0;
                                    }
                                    break block42;
                                }
                                case SHORT: {
                                    if (TypeMatcher.named((DeclaredType)receiver, "java.lang.Short")) {
                                        break block0;
                                    }
                                    break block42;
                                }
                                case DECLARED: {
                                    if (this.identical(receiver, payload) || this.assignable((DeclaredType)receiver, (DeclaredType)payload)) {
                                        break block0;
                                    }
                                    break block42;
                                }
                                default: {
                                    throw new IllegalArgumentException("Illegal payload kind: " + String.valueOf((Object)payload.getKind()) + "; payload: " + String.valueOf(payload));
                                }
                            }
                        }
                        default: {
                            throw new IllegalArgumentException("Illegal receiver kind: " + String.valueOf((Object)receiver.getKind()) + "; receiver: " + String.valueOf(receiver));
                        }
                    }
                }
                bl = true;
                break block43;
            }
            bl = false;
        }
        return bl;
    }

    public final TypeAndElementSource typeAndElementSource() {
        return this.tes;
    }

    private final boolean assignable(DeclaredType receiver, DeclaredType payload) {
        boolean bl;
        assert (receiver.getKind() == TypeKind.DECLARED);
        assert (payload.getKind() == TypeKind.DECLARED);
        DeclaredType declaredType = payload;
        Objects.requireNonNull(declaredType);
        DeclaredType declaredType2 = declaredType;
        int n = 0;
        block11: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DeclaredType.class, DeclaredType.class}, (Object)declaredType2, n)) {
                case 0: {
                    DeclaredType parameterizedPayload = declaredType2;
                    if (!TypeMatcher.parameterized(payload)) {
                        n = 1;
                        continue block11;
                    }
                    DeclaredType declaredType3 = receiver;
                    Objects.requireNonNull(declaredType3);
                    DeclaredType declaredType4 = declaredType3;
                    int n2 = 0;
                    block12: while (true) {
                        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DeclaredType.class, DeclaredType.class}, (Object)declaredType4, n2)) {
                            case 0: {
                                DeclaredType rawReceiver = declaredType4;
                                if (TypeMatcher.generic(receiver) && !TypeMatcher.raw(receiver)) {
                                    n2 = 1;
                                    continue block12;
                                }
                                if (this.identical(this.nonGenericClassOrRawType(rawReceiver), this.nonGenericClassOrRawType(parameterizedPayload)) && TypeMatcher.allTypeArgumentsAre(parameterizedPayload.getTypeArguments(), ((Predicate<TypeMirror>)this::unboundedTypeVariable).or(TypeMatcher::isJavaLangObject))) {
                                    bl = true;
                                    break block11;
                                }
                                bl = false;
                                break block11;
                            }
                            case 1: {
                                DeclaredType parameterizedReceiver = declaredType4;
                                if (!TypeMatcher.parameterized(receiver)) {
                                    n2 = 2;
                                    continue block12;
                                }
                                if (this.identical(this.rawType(parameterizedReceiver), this.rawType(parameterizedPayload))) {
                                    List<? extends TypeMirror> rtas = parameterizedReceiver.getTypeArguments();
                                    List<? extends TypeMirror> ptas = parameterizedPayload.getTypeArguments();
                                    assert (rtas.size() == ptas.size());
                                    for (int i = 0; i < rtas.size(); ++i) {
                                        TypeMirror rta = rtas.get(i);
                                        TypeMirror pta = ptas.get(i);
                                        if (TypeMatcher.actual(rta)) {
                                            if (TypeMatcher.actual(pta)) {
                                                if (this.identical(this.nonGenericClassOrRawType(rta), this.nonGenericClassOrRawType(pta))) {
                                                    if (TypeMatcher.cdiParameterized(rta)) {
                                                        assert (TypeMatcher.cdiParameterized(pta));
                                                        if (this.test(rta, pta)) continue;
                                                        bl = false;
                                                        break block11;
                                                    }
                                                    assert (!TypeMatcher.cdiParameterized(pta));
                                                    continue;
                                                }
                                                bl = false;
                                                break block11;
                                            }
                                            if (pta.getKind() == TypeKind.TYPEVAR) {
                                                if (this.assignableToCondensedTypeVariableBounds((TypeVariable)pta, (ReferenceType)rta)) continue;
                                                bl = false;
                                                break block11;
                                            }
                                            throw new AssertionError((Object)("Unexpected payload type argument kind: " + String.valueOf((Object)pta.getKind())));
                                        }
                                        if (rta.getKind() == TypeKind.WILDCARD) {
                                            if (TypeMatcher.actual(pta)) {
                                                if (this.assignableToCondensedExtendsBound((WildcardType)rta, (ReferenceType)pta) && this.assignableFromCondensedSuperBound((ReferenceType)pta, (WildcardType)rta)) continue;
                                                bl = false;
                                                break block11;
                                            }
                                            if (pta.getKind() == TypeKind.TYPEVAR) {
                                                if ((this.condensedTypeVariableBoundsAssignableToCondensedExtendsBound((WildcardType)rta, (TypeVariable)pta) || this.condensedTypeVariableBoundsAssignableFromCondensedExtendsBound((TypeVariable)pta, (WildcardType)rta)) && this.condensedTypeVariableBoundsAssignableFromCondensedSuperBound((TypeVariable)pta, (WildcardType)rta)) continue;
                                                bl = false;
                                                break block11;
                                            }
                                            throw new AssertionError((Object)("Unexpected payload type argument kind: " + String.valueOf((Object)pta.getKind())));
                                        }
                                        if (rta.getKind() == TypeKind.TYPEVAR) {
                                            if (pta.getKind() == TypeKind.TYPEVAR) {
                                                if (this.condensedTypeVariableBoundsAssignableToCondensedTypeVariableBounds((TypeVariable)pta, (TypeVariable)rta)) continue;
                                                bl = false;
                                                break block11;
                                            }
                                            throw new AssertionError((Object)("Unexpected payload type argument kind: " + String.valueOf((Object)pta.getKind())));
                                        }
                                        throw new AssertionError((Object)("Unexpected receiver type argument kind: " + String.valueOf((Object)rta.getKind())));
                                    }
                                    bl = true;
                                    break block11;
                                }
                                bl = false;
                                break block11;
                            }
                        }
                        break;
                    }
                    throw new AssertionError((Object)("Unexpected receiver kind: " + String.valueOf((Object)receiver.getKind())));
                }
                default: {
                    DeclaredType nonGenericOrRawPayload = declaredType2;
                    DeclaredType declaredType5 = receiver;
                    Objects.requireNonNull(declaredType5);
                    DeclaredType declaredType6 = declaredType5;
                    int n3 = 0;
                    block14: while (true) {
                        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DeclaredType.class, DeclaredType.class}, (Object)declaredType6, n3)) {
                            case 0: {
                                DeclaredType parameterizedReceiver = declaredType6;
                                if (!TypeMatcher.parameterized(receiver)) {
                                    n3 = 1;
                                    continue block14;
                                }
                                if (this.identical(this.nonGenericClassOrRawType(parameterizedReceiver), nonGenericOrRawPayload) && TypeMatcher.allTypeArgumentsAre(parameterizedReceiver.getTypeArguments(), ((Predicate<TypeMirror>)this::unboundedTypeVariable).or(TypeMatcher::isJavaLangObject))) {
                                    bl = true;
                                    break block11;
                                }
                                bl = false;
                                break block11;
                            }
                            case 1: {
                                DeclaredType nonGenericOrRawReceiver = declaredType6;
                                if (receiver.getKind() != TypeKind.DECLARED) {
                                    n3 = 2;
                                    continue block14;
                                }
                                bl = false;
                                break block11;
                            }
                        }
                        break;
                    }
                    throw new AssertionError((Object)("Unexpected payload kind: " + String.valueOf((Object)payload.getKind()) + "; receiver: " + String.valueOf(receiver) + "; payload: " + String.valueOf(payload)));
                }
            }
            break;
        }
        return bl;
    }

    private final boolean identical(TypeMirror receiver, TypeMirror payload) {
        return receiver == payload || this.tes.sameType(receiver, payload);
    }

    private final boolean assignableToCondensedTypeVariableBounds(TypeVariable receiver, ReferenceType payload) {
        assert (receiver.getKind() == TypeKind.TYPEVAR);
        assert (TypeMatcher.actual(payload));
        return this.covariantlyAssignable(List.of(receiver), List.of(payload));
    }

    private final boolean assignableToCondensedExtendsBound(WildcardType w, ReferenceType candidate) {
        boolean bl;
        block10: {
            block9: {
                block8: {
                    assert (w.getKind() == TypeKind.WILDCARD);
                    assert (TypeMatcher.actual(candidate));
                    ReferenceType extendsBound = (ReferenceType)w.getExtendsBound();
                    if (extendsBound == null) break block8;
                    switch (extendsBound.getKind()) {
                        case DECLARED: 
                        case ARRAY: {
                            if (this.covariantlyAssignable(extendsBound, candidate)) {
                                break;
                            }
                            break block9;
                        }
                        case TYPEVAR: {
                            if (this.covariantlyAssignable((ReferenceType)((Object)this.condense(extendsBound)), List.of(candidate))) {
                                break;
                            }
                            break block9;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                }
                bl = true;
                break block10;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean covariantlyAssignable(List<? extends TypeMirror> receiverBounds, List<? extends TypeMirror> payloadBounds) {
        payloadBounds = this.condense(payloadBounds);
        for (TypeMirror typeMirror : this.condense(receiverBounds)) {
            if (this.covariantlyAssignable((ReferenceType)typeMirror, payloadBounds)) continue;
            return false;
        }
        return true;
    }

    private final boolean covariantlyAssignable(ReferenceType classOrArrayTypeReceiver, List<? extends TypeMirror> condensedPayloadBounds) {
        assert (TypeMatcher.actual(classOrArrayTypeReceiver));
        return switch (classOrArrayTypeReceiver.getKind()) {
            case TypeKind.DECLARED, TypeKind.ARRAY -> {
                for (TypeMirror var4_4 : condensedPayloadBounds) {
                    if (!$assertionsDisabled && !TypeMatcher.actual(var4_4)) {
                        throw new AssertionError();
                    }
                    if (!this.covariantlyAssignable(classOrArrayTypeReceiver, (ReferenceType)var4_4)) continue;
                    yield true;
                }
                yield false;
            }
            default -> throw new IllegalArgumentException("classOrArrayTypeReceiver: " + String.valueOf(classOrArrayTypeReceiver) + "; kind: " + String.valueOf((Object)classOrArrayTypeReceiver.getKind()));
        };
    }

    private final boolean covariantlyAssignable(ReferenceType classOrArrayTypeReceiver, ReferenceType classOrArrayTypePayload) {
        assert (TypeMatcher.actual(classOrArrayTypeReceiver));
        assert (TypeMatcher.actual(classOrArrayTypePayload));
        return classOrArrayTypeReceiver == classOrArrayTypePayload || this.tes.assignable((TypeMirror)classOrArrayTypePayload, (TypeMirror)classOrArrayTypeReceiver);
    }

    private final boolean condensedTypeVariableBoundsAssignableToCondensedExtendsBound(WildcardType receiver, TypeVariable payload) {
        assert (receiver.getKind() == TypeKind.WILDCARD);
        assert (payload.getKind() == TypeKind.TYPEVAR);
        TypeMirror extendsBound = receiver.getExtendsBound();
        return extendsBound == null || this.covariantlyAssignable(List.of((ReferenceType)extendsBound), List.of(payload));
    }

    private final boolean condensedTypeVariableBoundsAssignableFromCondensedExtendsBound(TypeVariable receiver, WildcardType payload) {
        assert (receiver.getKind() == TypeKind.TYPEVAR);
        assert (payload.getKind() == TypeKind.WILDCARD);
        TypeMirror extendsBound = payload.getExtendsBound();
        return extendsBound == null || this.covariantlyAssignable(List.of(receiver), List.of((ReferenceType)extendsBound));
    }

    private final boolean condensedTypeVariableBoundsAssignableFromCondensedSuperBound(TypeVariable receiver, WildcardType payload) {
        assert (receiver.getKind() == TypeKind.TYPEVAR);
        assert (payload.getKind() == TypeKind.WILDCARD);
        TypeMirror superBound = payload.getSuperBound();
        return superBound == null || this.covariantlyAssignable(List.of(receiver), List.of(superBound));
    }

    private final boolean condensedTypeVariableBoundsAssignableToCondensedTypeVariableBounds(TypeVariable receiver, TypeVariable payload) {
        assert (receiver.getKind() == TypeKind.TYPEVAR);
        assert (payload.getKind() == TypeKind.TYPEVAR);
        return this.covariantlyAssignable(List.of(receiver), List.of(payload));
    }

    private final boolean assignableFromCondensedSuperBound(ReferenceType receiver, WildcardType payload) {
        boolean bl;
        block10: {
            block9: {
                block8: {
                    assert (payload.getKind() == TypeKind.WILDCARD);
                    assert (TypeMatcher.actual(receiver));
                    ReferenceType superBound = (ReferenceType)payload.getSuperBound();
                    if (superBound == null) break block8;
                    switch (superBound.getKind()) {
                        case DECLARED: 
                        case ARRAY: {
                            if (this.covariantlyAssignable(receiver, superBound)) {
                                break;
                            }
                            break block9;
                        }
                        case TYPEVAR: {
                            if (this.covariantlyAssignable(receiver, (ReferenceType)((Object)this.condense(superBound)))) {
                                break;
                            }
                            break block9;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                }
                bl = true;
                break block10;
            }
            bl = false;
        }
        return bl;
    }

    private final TypeMirror rawType(TypeMirror t) {
        return switch (t.getKind()) {
            case TypeKind.ARRAY -> {
                TypeMirror et = TypeMatcher.elementType(t);
                if (!TypeMatcher.parameterized(et)) {
                    throw new IllegalArgumentException("t is an array type whose element type is not parameterized so cannot yield a raw type");
                }
                yield this.arrayTypeOf(this.erasure(et));
            }
            case TypeKind.DECLARED -> {
                if (!TypeMatcher.parameterized(t)) {
                    throw new IllegalArgumentException("t is a declared type that is not parameterized so cannot yield a raw type");
                }
                yield this.erasure(t);
            }
            default -> throw new IllegalArgumentException("t is a " + String.valueOf((Object)t.getKind()) + " type and so cannot yield a raw type");
        };
    }

    private final TypeMirror nonGenericClassOrRawType(TypeMirror t) {
        return TypeMatcher.yieldsRawType(t) ? this.rawType(t) : t;
    }

    private final TypeMirror erasure(TypeMirror t) {
        return this.tes.erasure(t);
    }

    private final ArrayType arrayTypeOf(TypeMirror componentType) {
        return this.tes.arrayTypeOf(componentType);
    }

    private final List<? extends TypeMirror> condense(TypeMirror t) {
        List<Object> list;
        if (t == null) {
            list = List.of();
        } else {
            switch (t.getKind()) {
                case INTERSECTION: {
                    list = this.condense(((IntersectionType)t).getBounds());
                    break;
                }
                case TYPEVAR: {
                    list = this.condense(((TypeVariable)t).getUpperBound());
                    break;
                }
                case WILDCARD: {
                    WildcardType w = (WildcardType)t;
                    TypeMirror s = w.getSuperBound();
                    TypeMirror e = w.getExtendsBound();
                    if (s == null) {
                        if (e == null) {
                            list = List.of(this.tes.declaredType((CharSequence)"java.lang.Object"));
                            break;
                        }
                        list = this.condense(e);
                        break;
                    }
                    if (e == null) {
                        list = this.condense(s);
                        break;
                    }
                    throw new AssertionError();
                }
                default: {
                    list = List.of(t);
                }
            }
        }
        return list;
    }

    private final List<? extends TypeMirror> condense(List<? extends TypeMirror> ts) {
        int size;
        int n = size = ts.isEmpty() ? 0 : ts.size();
        if (size == 0) {
            return List.of();
        }
        ArrayList<? extends TypeMirror> newBounds = null;
        block3: for (int i = 0; i < size; ++i) {
            TypeMirror t = ts.get(i);
            switch (t.getKind()) {
                case TYPEVAR: 
                case INTERSECTION: 
                case WILDCARD: {
                    if (newBounds == null) {
                        newBounds = new ArrayList<TypeMirror>(size * 2);
                        if (i > 0) {
                            newBounds.addAll(ts.subList(0, i));
                        }
                    }
                    newBounds.addAll(this.condense(t));
                    continue block3;
                }
                default: {
                    if (newBounds == null) continue block3;
                    newBounds.add(t);
                }
            }
        }
        if (newBounds == null) {
            return ts;
        }
        newBounds.trimToSize();
        return Collections.unmodifiableList(newBounds);
    }

    private final boolean unboundedTypeVariable(TypeMirror t) {
        return switch (t.getKind()) {
            case TypeKind.TYPEVAR -> {
                List<? extends TypeMirror> condensedBounds = this.condense(((TypeVariable)t).getUpperBound());
                if (condensedBounds.size() == 1 && TypeMatcher.isJavaLangObject(condensedBounds.get(0))) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private static final boolean generic(Element e) {
        return switch (e.getKind()) {
            case ElementKind.CLASS, ElementKind.CONSTRUCTOR, ElementKind.ENUM, ElementKind.INTERFACE, ElementKind.METHOD, ElementKind.RECORD -> {
                if (!((Parameterizable)e).getTypeParameters().isEmpty()) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private static final boolean generic(TypeMirror t) {
        return t.getKind() == TypeKind.DECLARED && TypeMatcher.generic(((DeclaredType)t).asElement());
    }

    private static final boolean parameterized(TypeMirror t) {
        return t.getKind() == TypeKind.DECLARED && !((DeclaredType)t).getTypeArguments().isEmpty();
    }

    private static final boolean cdiParameterized(TypeMirror t) {
        return TypeMatcher.yieldsRawType(t);
    }

    private static final boolean yieldsRawType(TypeMirror t) {
        return TypeMatcher.parameterized(t) || t.getKind() == TypeKind.ARRAY && TypeMatcher.parameterized(TypeMatcher.elementType(t));
    }

    private static final boolean raw(TypeMirror t) {
        return switch (t.getKind()) {
            case TypeKind.ARRAY -> TypeMatcher.raw(TypeMatcher.elementType((ArrayType)t));
            case TypeKind.DECLARED -> {
                if (TypeMatcher.generic(t) && ((DeclaredType)t).getTypeArguments().isEmpty()) {
                    yield true;
                }
                yield false;
            }
            case TypeKind.TYPEVAR -> false;
            default -> false;
        };
    }

    private static final boolean declaredTypeNamed(TypeMirror t, CharSequence n) {
        return t.getKind() == TypeKind.DECLARED && TypeMatcher.named((DeclaredType)t, n);
    }

    private static final boolean named(DeclaredType t, CharSequence n) {
        return ((QualifiedNameable)t.asElement()).getQualifiedName().contentEquals(n);
    }

    private static final boolean allTypeArgumentsAre(Iterable<? extends TypeMirror> typeArguments, Predicate<? super TypeMirror> p) {
        for (TypeMirror typeMirror : typeArguments) {
            if (p.test(typeMirror)) continue;
            return false;
        }
        return true;
    }

    private static final boolean isJavaLangObject(Element e) {
        return e.getKind() == ElementKind.CLASS && ((QualifiedNameable)e).getQualifiedName().contentEquals("java.lang.Object");
    }

    private static final boolean isJavaLangObject(TypeMirror t) {
        return t.getKind() == TypeKind.DECLARED && TypeMatcher.isJavaLangObject(((DeclaredType)t).asElement());
    }

    private static final boolean actual(TypeMirror t) {
        return switch (t.getKind()) {
            case TypeKind.BOOLEAN, TypeKind.BYTE, TypeKind.CHAR, TypeKind.DOUBLE, TypeKind.FLOAT, TypeKind.INT, TypeKind.LONG, TypeKind.SHORT, TypeKind.DECLARED, TypeKind.ARRAY -> true;
            default -> false;
        };
    }

    private static final TypeMirror elementType(TypeMirror t) {
        return t.getKind() == TypeKind.ARRAY ? TypeMatcher.elementType(((ArrayType)t).getComponentType()) : t;
    }
}

