/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.bean;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.SequencedSet;
import java.util.function.Function;
import org.microbean.bean.Assignment;
import org.microbean.bean.AttributedElement;
import org.microbean.bean.AttributedType;

public interface Aggregate {
    public static final SequencedSet<Assignment<?>> EMPTY_ASSIGNMENTS = Collections.unmodifiableSequencedSet(LinkedHashSet.newLinkedHashSet(0));
    public static final SequencedSet<AttributedElement> EMPTY_DEPENDENCIES = Collections.unmodifiableSequencedSet(LinkedHashSet.newLinkedHashSet(0));

    default public SequencedSet<AttributedElement> dependencies() {
        return EMPTY_DEPENDENCIES;
    }

    default public SequencedSet<? extends Assignment<?>> assign(Function<? super AttributedType, ?> r) {
        SequencedSet<AttributedElement> ds = this.dependencies();
        if (ds == null || ds.isEmpty()) {
            return EMPTY_ASSIGNMENTS;
        }
        LinkedHashSet assignments = LinkedHashSet.newLinkedHashSet(ds.size());
        ds.forEach(d -> assignments.add(new Assignment((AttributedElement)d, r.apply(d.attributedType()))));
        return Collections.unmodifiableSequencedSet(assignments);
    }
}

