/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.bean;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.microbean.assign.Matcher;
import org.microbean.bean.AttributedType;
import org.microbean.bean.Bean;
import org.microbean.bean.BeanQualifiersMatcher;
import org.microbean.bean.BeanTypeMatcher;
import org.microbean.bean.Id;
import org.microbean.bean.IdMatcher;
import org.microbean.bean.InterceptorBindingsMatcher;
import org.microbean.bean.Ranked;
import org.microbean.bean.RankedReducer;
import org.microbean.bean.Reducer;
import org.microbean.bean.Reducible;
import org.microbean.bean.Selectable;
import org.microbean.construct.Domain;

public final class Beans
implements Selectable<AttributedType, Bean<?>>,
Reducible<AttributedType, Bean<?>> {
    private static final System.Logger LOGGER = System.getLogger(Beans.class.getName());
    private static final Comparator<Bean<?>> byRankComparator = Comparator.comparingInt(Ranked::rank).reversed();
    private static final Comparator<Bean<?>> byAlternateThenByRankComparator = Comparator.comparing(Ranked::alternate).reversed().thenComparing(byRankComparator);
    private final Selectable<AttributedType, Bean<?>> s;
    private final Reducible<AttributedType, Bean<?>> r;

    public Beans(Domain domain, Bean<?> ... beans) {
        this(domain, beans == null || beans.length == 0 ? List.of() : List.of(beans));
    }

    public Beans(Domain domain, Collection<? extends Bean<?>> beans) {
        this(Beans.cachingSelectableOf(beans, new IdMatcher(new BeanQualifiersMatcher(), new InterceptorBindingsMatcher(), new BeanTypeMatcher(domain)), Map.of()));
    }

    public Beans(Selectable<AttributedType, Bean<?>> s) {
        this(s, (Reducer)null);
    }

    public Beans(Selectable<AttributedType, Bean<?>> s, Reducer<AttributedType, Bean<?>> r) {
        this(s, Reducible.of(s, r == null ? RankedReducer.of() : r));
    }

    public Beans(Selectable<AttributedType, Bean<?>> s, Reducible<AttributedType, Bean<?>> r) {
        this.s = Objects.requireNonNull(s, "s");
        this.r = Objects.requireNonNull(r, "r");
    }

    @Override
    public final List<Bean<?>> select(AttributedType c) {
        return this.s.select(c);
    }

    @Override
    public final Bean<?> reduce(AttributedType c) {
        return this.r.reduce(c);
    }

    public static final Selectable<AttributedType, Bean<?>> cachingSelectableOf(Collection<? extends Bean<?>> beans, Matcher<? super AttributedType, ? super Id> idMatcher, Map<? extends AttributedType, ? extends List<Bean<?>>> selections) {
        Objects.requireNonNull(idMatcher, "idMatcher");
        ConcurrentHashMap selectionCache = new ConcurrentHashMap();
        ArrayList<Bean> newBeans = new ArrayList<Bean>(31);
        HashSet newBeansSet = HashSet.newHashSet(31);
        for (Map.Entry<AttributedType, List<Bean<?>>> entry : selections.entrySet()) {
            List<Bean<?>> selection = entry.getValue();
            if (selection.isEmpty()) continue;
            HashSet newSelectionSet = HashSet.newHashSet(7);
            ArrayList newSelection = new ArrayList(selection.size());
            for (Bean<?> b : selection) {
                if (newSelectionSet.add(b)) {
                    newSelection.add(b);
                }
                if (!newBeansSet.add(b)) continue;
                newBeans.add(b);
            }
            newSelectionSet.clear();
            newSelection.trimToSize();
            Collections.sort(newSelection, byAlternateThenByRankComparator);
            selectionCache.put(entry.getKey(), Collections.unmodifiableList(newSelection));
        }
        for (Bean bean : beans) {
            if (!newBeansSet.add(bean)) continue;
            newBeans.add(bean);
        }
        newBeansSet.clear();
        if (newBeans.isEmpty()) {
            return Beans::empty;
        }
        Collections.sort(newBeans, byAlternateThenByRankComparator);
        newBeans.trimToSize();
        return attributedType -> selectionCache.computeIfAbsent((AttributedType)attributedType, at -> newBeans.stream().filter(b -> idMatcher.test(at, (Object)b.id())).toList());
    }

    private static final <C, T> List<T> empty(C ignored) {
        return List.of();
    }
}

