/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.bean;

import java.lang.constant.ClassDesc;
import java.lang.constant.Constable;
import java.lang.constant.ConstantDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.DynamicConstantDesc;
import java.lang.constant.MethodHandleDesc;
import java.util.Optional;
import org.microbean.bean.Aggregate;
import org.microbean.bean.Creation;
import org.microbean.bean.Destruction;
import org.microbean.bean.DestructionException;

public interface Factory<I>
extends Aggregate,
Constable {
    public I create(Creation<I> var1);

    @Override
    default public Optional<? extends ConstantDesc> describeConstable() {
        return Optional.of(DynamicConstantDesc.of(ConstantDescs.BSM_INVOKE, MethodHandleDesc.ofConstructor(ClassDesc.of(this.getClass().getCanonicalName()), new ClassDesc[0])));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public void destroy(I i, Destruction creation) {
        if (creation == null) {
            if (!(i instanceof AutoCloseable)) return;
            AutoCloseable ac = (AutoCloseable)i;
            try {
                ac.close();
                return;
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new DestructionException(e.getMessage(), e);
            }
            catch (Exception e) {
                throw new DestructionException(e.getMessage(), e);
            }
        }
        if (!(creation instanceof Creation)) {
            throw new IllegalArgumentException("creation: " + String.valueOf(creation));
        }
        if (creation instanceof AutoCloseable) {
            Destruction cac = creation;
            try (Destruction ac = cac;){
                if (!(i instanceof AutoCloseable)) return;
                AutoCloseable iac = (AutoCloseable)i;
                iac.close();
                return;
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new DestructionException(e.getMessage(), e);
            }
            catch (Exception e) {
                throw new DestructionException(e.getMessage(), e);
            }
        }
        if (!(i instanceof AutoCloseable)) return;
        AutoCloseable ac = (AutoCloseable)i;
        try {
            ac.close();
            return;
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new DestructionException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new DestructionException(e.getMessage(), e);
        }
    }

    default public boolean destroys() {
        return true;
    }

    default public I singleton() {
        return null;
    }
}

