/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.bean;

import java.util.List;
import java.util.Objects;
import javax.lang.model.type.TypeMirror;
import org.microbean.assign.Matcher;
import org.microbean.attributes.Attributes;
import org.microbean.bean.AttributedType;
import org.microbean.bean.BeanQualifiersMatcher;
import org.microbean.bean.BeanTypeMatcher;
import org.microbean.bean.Id;
import org.microbean.bean.InterceptorBindingsMatcher;

public final class IdMatcher
implements Matcher<AttributedType, Id> {
    private final BeanQualifiersMatcher qm;
    private final InterceptorBindingsMatcher ibm;
    private final BeanTypeMatcher tm;

    public IdMatcher(BeanQualifiersMatcher qm, InterceptorBindingsMatcher ibm, BeanTypeMatcher tm) {
        this.qm = Objects.requireNonNull(qm, "qm");
        this.ibm = Objects.requireNonNull(ibm, "ibm");
        this.tm = Objects.requireNonNull(tm, "tm");
    }

    public final boolean test(AttributedType t, Id id) {
        List<Attributes> idAttributes;
        List<Attributes> attributes = t.attributes();
        return this.qm.test(attributes, idAttributes = id.attributes()) && this.ibm.test(attributes, idAttributes) && this.test(t.type(), id.types());
    }

    public final boolean test(TypeMirror type, Iterable<? extends TypeMirror> ts) {
        Objects.requireNonNull(type, "type");
        for (TypeMirror typeMirror : ts) {
            if (!this.tm.test(type, typeMirror)) continue;
            return true;
        }
        return false;
    }
}

