/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.bean;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;

@FunctionalInterface
public interface Selectable<C, T> {
    public List<T> select(C var1);

    default public List<T> list() {
        return this.select(null);
    }

    public static <C, E> Selectable<C, E> of(Collection<? extends E> collection, BiFunction<? super E, ? super C, ? extends Boolean> f) {
        Objects.requireNonNull(f, "f");
        return collection.isEmpty() ? Selectable.of() : c -> collection.stream().filter(e -> (Boolean)f.apply((Object)e, (Object)c)).toList();
    }

    public static <C, E> Selectable<C, E> of() {
        return c -> List.of();
    }

    public static <C, E> Selectable<C, E> ofCaching(Collection<? extends E> collection, BiFunction<? super E, ? super C, ? extends Boolean> f) {
        Objects.requireNonNull(f, "f");
        if (collection.isEmpty()) {
            return c -> List.of();
        }
        ConcurrentHashMap m = new ConcurrentHashMap();
        return c -> m.computeIfAbsent(c, fc -> collection.stream().filter(e -> (Boolean)f.apply((Object)e, (Object)fc)).toList());
    }
}

