/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.bean;

import java.lang.constant.ClassDesc;
import java.lang.constant.Constable;
import java.lang.constant.ConstantDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.DynamicConstantDesc;
import java.lang.constant.MethodHandleDesc;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.lang.model.type.TypeMirror;
import org.microbean.attributes.Attributed;
import org.microbean.attributes.Attributes;
import org.microbean.constant.Constables;

public record AttributedType(TypeMirror type, List<Attributes> attributes) implements Attributed,
Constable
{
    public AttributedType(TypeMirror type, Attributes ... attributes) {
        this(type, attributes == null || attributes.length <= 0 ? List.of() : Arrays.asList(attributes));
    }

    public AttributedType {
        switch (type.getKind()) {
            case ARRAY: 
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case DECLARED: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case SHORT: {
                break;
            }
            default: {
                throw new IllegalArgumentException("type: " + String.valueOf(type));
            }
        }
        attributes = List.copyOf(attributes);
    }

    public AttributedType(TypeMirror type) {
        this(type, List.of());
    }

    @Override
    public Optional<? extends ConstantDesc> describeConstable() {
        Optional<Object> optional;
        TypeMirror typeMirror = this.type();
        if (typeMirror instanceof Constable) {
            Constable t = (Constable)((Object)typeMirror);
            optional = t.describeConstable();
        } else {
            optional = Optional.empty().flatMap(typeDesc -> Constables.describeConstable(this.attributes()).map(attributesDesc -> DynamicConstantDesc.of(ConstantDescs.BSM_INVOKE, MethodHandleDesc.ofConstructor(ClassDesc.of(this.getClass().getName()), ClassDesc.of(TypeMirror.class.getName()), ConstantDescs.CD_List), typeDesc, attributesDesc)));
        }
        return optional;
    }

    public static final AttributedType of(TypeMirror type, Attributes ... attributes) {
        return new AttributedType(type, attributes == null || attributes.length <= 0 ? List.of() : Arrays.asList(attributes));
    }
}

