/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.bean;

import java.lang.constant.ClassDesc;
import java.lang.constant.Constable;
import java.lang.constant.ConstantDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.DirectMethodHandleDesc;
import java.lang.constant.DynamicConstantDesc;
import java.lang.constant.MethodHandleDesc;
import java.lang.constant.MethodTypeDesc;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.microbean.assign.ClassesThenInterfacesElementKindComparator;
import org.microbean.assign.PrimitiveAndReferenceTypeKindComparator;
import org.microbean.assign.SpecializationComparator;
import org.microbean.assign.SupertypeList;
import org.microbean.assign.Types;
import org.microbean.bean.BeanTypes;
import org.microbean.constant.Constables;
import org.microbean.construct.Domain;

public final class BeanTypeList
extends AbstractList<TypeMirror>
implements Constable {
    private final Domain domain;
    private final List<TypeMirror> types;
    private final int interfaceIndex;
    private final boolean proxiable;

    /*
     * WARNING - void declaration
     */
    private BeanTypeList(Domain domain, Collection<? extends TypeMirror> types) {
        Objects.requireNonNull(types, "types");
        if (types instanceof BeanTypeList) {
            BeanTypeList btl = (BeanTypeList)types;
            this.domain = btl.domain;
            this.types = btl.types;
            this.interfaceIndex = btl.interfaceIndex;
            this.proxiable = btl.proxiable;
        } else {
            this.domain = domain;
            int size = types.size();
            if (size == 0) {
                this.types = List.of();
                this.interfaceIndex = -1;
                this.proxiable = false;
            } else if (types instanceof SupertypeList) {
                int i;
                SupertypeList stl = (SupertypeList)types;
                for (i = 0; i < size && BeanTypes.legalBeanType(stl.get(i)); ++i) {
                }
                if (i == size) {
                    Object newTypes = null;
                    this.types = List.copyOf(types);
                    this.interfaceIndex = stl.interfaceIndex();
                    this.proxiable = BeanTypeList.proxiable(this.types.get(0), size);
                } else {
                    void var8_13;
                    ArrayList<TypeMirror> newTypes = new ArrayList<TypeMirror>(size);
                    boolean bl = false;
                    while (var8_13 < i) {
                        newTypes.add(stl.get((int)var8_13));
                        ++var8_13;
                    }
                    ++i;
                    while (i < size) {
                        TypeMirror typeMirror = stl.get(i);
                        if (BeanTypes.legalBeanType(typeMirror)) {
                            newTypes.add(typeMirror);
                        }
                        ++i;
                    }
                    newTypes.trimToSize();
                    size = newTypes.size();
                    if (newTypes.isEmpty()) {
                        this.types = List.of();
                        this.interfaceIndex = -1;
                        this.proxiable = false;
                    } else {
                        this.types = Collections.unmodifiableList(newTypes);
                        this.interfaceIndex = stl.interfaceIndex() >= size ? -1 : stl.interfaceIndex();
                        this.proxiable = BeanTypeList.proxiable((TypeMirror)newTypes.get(0), size);
                    }
                }
            } else {
                ArrayList<TypeMirror> newTypes = new ArrayList<TypeMirror>(size);
                for (TypeMirror typeMirror : types) {
                    if (!BeanTypes.legalBeanType(typeMirror)) continue;
                    newTypes.add(typeMirror);
                }
                if (newTypes.isEmpty()) {
                    this.types = List.of();
                    this.interfaceIndex = -1;
                    this.proxiable = false;
                } else {
                    void var8_17;
                    newTypes.trimToSize();
                    size = newTypes.size();
                    if (size > 1) {
                        Collections.sort(newTypes, Comparator.comparing(TypeMirror::getKind, PrimitiveAndReferenceTypeKindComparator.INSTANCE).thenComparing((Comparator<TypeMirror>)new SpecializationComparator(domain)).thenComparing(this::elementKind, ClassesThenInterfacesElementKindComparator.INSTANCE).thenComparing(Types::erasedName));
                    }
                    this.types = Collections.unmodifiableList(newTypes);
                    int interfaceIndex = -1;
                    boolean bl = false;
                    while (var8_17 < size) {
                        ElementKind k = this.elementKind((TypeMirror)newTypes.get((int)var8_17));
                        if (k != null && k.isInterface()) {
                            interfaceIndex = var8_17;
                            break;
                        }
                        ++var8_17;
                    }
                    this.interfaceIndex = interfaceIndex;
                    this.proxiable = BeanTypeList.proxiable((TypeMirror)newTypes.get(0), size);
                }
            }
        }
    }

    private ElementKind elementKind(TypeMirror t) {
        Element e = this.domain.element(t);
        return e == null ? null : e.getKind();
    }

    @Override
    public final TypeMirror get(int index) {
        return this.types.get(index);
    }

    public final int interfaceIndex() {
        return this.interfaceIndex;
    }

    @Override
    public final boolean isEmpty() {
        return this.types.isEmpty();
    }

    @Override
    public final Optional<? extends ConstantDesc> describeConstable() {
        Optional<ConstantDesc> optional;
        Domain domain = this.domain;
        if (domain instanceof Constable) {
            Constable c = (Constable)domain;
            optional = c.describeConstable();
        } else {
            optional = Optional.empty();
        }
        return optional.flatMap(domainDesc -> Constables.describeConstable(this.types).map(typesDesc -> DynamicConstantDesc.of(ConstantDescs.BSM_INVOKE, MethodHandleDesc.ofMethod(DirectMethodHandleDesc.Kind.STATIC, ClassDesc.of(this.getClass().getName()), "of", MethodTypeDesc.of(ClassDesc.of(BeanTypeList.class.getName()), ClassDesc.of(Domain.class.getName()), ConstantDescs.CD_Collection)), domainDesc, typesDesc)));
    }

    public final boolean proxiable() {
        return this.proxiable;
    }

    @Override
    public final int size() {
        return this.types.size();
    }

    public static final BeanTypeList of(Domain domain, Collection<? extends TypeMirror> types) {
        BeanTypeList btl;
        return types instanceof BeanTypeList ? (btl = (BeanTypeList)types) : new BeanTypeList(domain, types);
    }

    private static final boolean proxiable(TypeMirror firstLegalBeanType, int size) {
        TypeElement e;
        Element element;
        return firstLegalBeanType.getKind() == TypeKind.DECLARED && (element = ((DeclaredType)firstLegalBeanType).asElement()) instanceof TypeElement && (BeanTypes.proxiableElement(e = (TypeElement)element) || e.getQualifiedName().contentEquals("java.lang.Object") && size > 1);
    }
}

