/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.bean;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.microbean.bean.Bean;
import org.microbean.bean.Ranked;

public final class Beans {
    private static final System.Logger LOGGER = System.getLogger(Beans.class.getName());
    private static final Comparator<Bean<?>> byRankComparator = Comparator.comparingInt(Ranked::rank).reversed();
    private static final Comparator<Bean<?>> byAlternateThenByRankComparator = Comparator.comparing(Ranked::alternate).reversed().thenComparing(byRankComparator);

    private Beans() {
    }

    public static List<Bean<?>> normalize(Collection<? extends Bean<?>> beans) {
        if (beans.isEmpty()) {
            return List.of();
        }
        if (beans.size() == 1) {
            return List.copyOf(beans);
        }
        ArrayList newBeans = new ArrayList(beans.size());
        if (beans instanceof Set) {
            newBeans.addAll(beans);
        } else {
            HashSet newBeansSet = HashSet.newHashSet(beans.size());
            for (Bean<?> bean : beans) {
                if (!newBeansSet.add(bean)) continue;
                newBeans.add(bean);
            }
            if (newBeans.isEmpty()) {
                return List.of();
            }
        }
        assert (!newBeans.isEmpty());
        if (newBeans.size() > 1) {
            Collections.sort(newBeans, byAlternateThenByRankComparator);
        }
        return List.copyOf(newBeans);
    }
}

