/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.bean;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.microbean.assign.Matcher;
import org.microbean.bean.AttributedType;
import org.microbean.bean.Bean;
import org.microbean.bean.Beans;
import org.microbean.bean.Id;
import org.microbean.bean.Ranked;
import org.microbean.bean.Selectable;

public final class Selectables {
    private Selectables() {
    }

    public static final <C, E extends Ranked> Selectable<C, E> ambiguityReducing(Selectable<C, E> s) {
        Objects.requireNonNull(s, "s");
        return c -> {
            List elements = s.select(c);
            if (elements.isEmpty()) {
                return List.of();
            }
            if (elements.size() == 1) {
                return List.of((Ranked)elements.get(0));
            }
            int maxRank = Integer.MIN_VALUE;
            ArrayList<Ranked> reductionList = new ArrayList<Ranked>(elements.size());
            boolean reductionListContainsOnlyRankedAlternates = false;
            for (Ranked element : elements) {
                if (!element.alternate()) continue;
                int rank = element.rank();
                if (rank == 0) {
                    if (reductionListContainsOnlyRankedAlternates) {
                        reductionListContainsOnlyRankedAlternates = false;
                    }
                    reductionList.add(element);
                    continue;
                }
                if (reductionList.isEmpty()) {
                    assert (!reductionListContainsOnlyRankedAlternates) : "Unexpected reductionListContainsOnlyRankedAlternates: " + reductionListContainsOnlyRankedAlternates;
                    if (rank > maxRank) {
                        maxRank = rank;
                    }
                    reductionList.add(element);
                    reductionListContainsOnlyRankedAlternates = true;
                    continue;
                }
                if (reductionListContainsOnlyRankedAlternates) {
                    assert (reductionList.size() == 1) : "Unexpected reductionList size: " + String.valueOf(reductionList);
                    if (rank <= maxRank) continue;
                    maxRank = rank;
                    reductionList.set(0, element);
                    continue;
                }
                reductionList.add(element);
            }
            assert (!reductionListContainsOnlyRankedAlternates || reductionList.size() == 1) : "Unexpected reductionList size: " + String.valueOf(reductionList);
            if (reductionList.isEmpty()) {
                return elements;
            }
            if (reductionList.size() == 1) {
                return List.of((Ranked)reductionList.get(0));
            }
            return List.copyOf(reductionList);
        };
    }

    public static <C, E> Selectable<C, E> caching(Selectable<C, E> selectable) {
        ConcurrentHashMap selectionCache = new ConcurrentHashMap();
        return Selectables.caching(selectable, selectionCache::computeIfAbsent);
    }

    public static <C, E> Selectable<C, E> caching(Selectable<C, E> selectable, BiFunction<? super C, Function<? super C, ? extends List<E>>, ? extends List<E>> f) {
        Objects.requireNonNull(selectable, "selectable");
        return c -> (List)f.apply((Object)c, selectable::select);
    }

    public static final <C, E> Selectable<C, E> empty() {
        return Selectables::empty;
    }

    private static final <C, E> List<E> empty(C ignored) {
        return List.of();
    }

    public static <C, E> Selectable<C, E> filtering(Collection<? extends E> collection, BiFunction<? super E, ? super C, ? extends Boolean> f) {
        Objects.requireNonNull(f, "f");
        return collection.isEmpty() ? Selectables.empty() : c -> collection.stream().filter(e -> (Boolean)f.apply((Object)e, (Object)c)).toList();
    }

    public static final Selectable<AttributedType, Bean<?>> typesafeReducing(Collection<? extends Bean<?>> beans, Matcher<? super AttributedType, ? super Id> m) {
        Objects.requireNonNull(m, "m");
        List<Bean<?>> normalizedBeans = Beans.normalize(beans);
        return normalizedBeans.isEmpty() ? Selectables.empty() : Selectables.filtering(normalizedBeans, (b, c) -> m.test(c, (Object)b.id()));
    }
}

