/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.bean;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.microbean.assign.Types;
import org.microbean.bean.BeanTypeList;
import org.microbean.construct.Domain;

public final class BeanTypes
extends Types {
    private static final System.Logger LOGGER = System.getLogger(BeanTypes.class.getName());
    private final Map<TypeMirror, BeanTypeList> beanTypesCache = new ConcurrentHashMap<TypeMirror, BeanTypeList>();

    public BeanTypes(Domain domain) {
        super(domain);
    }

    public final BeanTypeList beanTypes(TypeMirror t) {
        Domain d = this.domain();
        return switch (t.getKind()) {
            case TypeKind.ARRAY -> this.beanTypesCache.computeIfAbsent(t, t0 -> BeanTypeList.of(d, BeanTypes.legalBeanType(t0) ? List.of(t0, d.javaLangObject().asType()) : List.of()));
            case TypeKind.BOOLEAN, TypeKind.BYTE, TypeKind.CHAR, TypeKind.DOUBLE, TypeKind.FLOAT, TypeKind.INT, TypeKind.LONG, TypeKind.SHORT -> this.beanTypesCache.computeIfAbsent(t, t0 -> BeanTypeList.of(d, List.of(t0, d.javaLangObject().asType())));
            case TypeKind.DECLARED, TypeKind.TYPEVAR -> this.beanTypesCache.computeIfAbsent(t, t0 -> BeanTypeList.of(d, (Collection<? extends TypeMirror>)this.supertypes((TypeMirror)t0, BeanTypes::legalBeanType)));
            default -> BeanTypeList.of(d, List.of());
        };
    }

    public final void clearCaches() {
        this.beanTypesCache.clear();
    }

    public static final boolean legalBeanType(TypeMirror t) {
        return switch (t.getKind()) {
            case TypeKind.ARRAY -> {
                if (!BeanTypes.legalBeanType(((ArrayType)t).getComponentType())) {
                    if (LOGGER.isLoggable(System.Logger.Level.WARNING)) {
                        LOGGER.log(System.Logger.Level.WARNING, String.valueOf(t) + " has a component type that is an illegal bean type (" + String.valueOf(((ArrayType)t).getComponentType()) + ")");
                    }
                    yield false;
                }
                yield true;
            }
            case TypeKind.BOOLEAN, TypeKind.BYTE, TypeKind.CHAR, TypeKind.DOUBLE, TypeKind.FLOAT, TypeKind.INT, TypeKind.LONG, TypeKind.SHORT -> true;
            case TypeKind.DECLARED -> {
                for (TypeMirror var2_2 : ((DeclaredType)t).getTypeArguments()) {
                    if (var2_2.getKind() == TypeKind.TYPEVAR || BeanTypes.legalBeanType(var2_2)) continue;
                    if (LOGGER.isLoggable(System.Logger.Level.WARNING)) {
                        LOGGER.log(System.Logger.Level.WARNING, String.valueOf(t) + " has a type argument that is an illegal bean type (" + String.valueOf(var2_2) + ")");
                    }
                    yield false;
                }
                yield true;
            }
            default -> {
                if (LOGGER.isLoggable(System.Logger.Level.WARNING)) {
                    LOGGER.log(System.Logger.Level.WARNING, String.valueOf(t) + " is an illegal bean type");
                }
                yield false;
            }
        };
    }

    public static final boolean proxiableBeanType(TypeMirror t) {
        return t.getKind() == TypeKind.DECLARED && BeanTypes.legalBeanType(t) && BeanTypes.proxiableElement(((DeclaredType)t).asElement());
    }

    static final boolean proxiableElement(Element e) {
        switch (e.getKind()) {
            case CLASS: {
                if (e.getModifiers().contains((Object)Modifier.FINAL) || e.getModifiers().contains((Object)Modifier.SEALED) || ((QualifiedNameable)e).getQualifiedName().contentEquals("java.lang.Object")) {
                    return false;
                }
                boolean hasNonPrivateZeroArgumentConstructor = false;
                for (Element element : e.getEnclosedElements()) {
                    switch (element.getKind()) {
                        case CONSTRUCTOR: {
                            if (hasNonPrivateZeroArgumentConstructor || element.getModifiers().contains((Object)Modifier.PRIVATE) || !((ExecutableElement)element).getParameters().isEmpty()) break;
                            hasNonPrivateZeroArgumentConstructor = true;
                            break;
                        }
                        case METHOD: {
                            Set<Modifier> modifiers = ((ExecutableElement)element).getModifiers();
                            if (!modifiers.contains((Object)Modifier.FINAL) || modifiers.contains((Object)Modifier.STATIC) || modifiers.contains((Object)Modifier.PRIVATE)) break;
                            return false;
                        }
                    }
                }
                return hasNonPrivateZeroArgumentConstructor;
            }
            case INTERFACE: {
                return true;
            }
        }
        return false;
    }
}

