/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.bean;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.function.Consumer;

public final class DisposableReference<R>
extends WeakReference<R>
implements AutoCloseable {
    private static final System.Logger LOGGER = System.getLogger(DisposableReference.class.getName());
    private static final VarHandle DISPOSED;
    private final R referent;
    private final Consumer<? super R> disposer;
    private volatile boolean disposed;

    public DisposableReference(R referent, Consumer<? super R> disposer) {
        super(Objects.requireNonNull(referent, "referent"), ReferenceQueue.INSTANCE);
        this.referent = referent;
        this.disposer = disposer == null ? DisposableReference::noopDispose : disposer;
    }

    @Override
    public final void close() {
        this.enqueue();
    }

    public final boolean closed() {
        return this.refersTo(null);
    }

    public final boolean dispose() {
        if (DISPOSED.compareAndSet(this, false, true)) {
            try {
                this.disposer.accept(this.referent);
            }
            catch (Error | RuntimeException e) {
                this.disposed = false;
                throw e;
            }
            return true;
        }
        return false;
    }

    public final boolean disposed() {
        return this.disposed;
    }

    private static final <R> void noopDispose(R r) {
        if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
            LOGGER.log(System.Logger.Level.DEBUG, "DisposableReference referent " + String.valueOf(r) + " has been cleared");
        }
    }

    static {
        try {
            DISPOSED = MethodHandles.lookup().findVarHandle(DisposableReference.class, "disposed", Boolean.TYPE);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw (Error)new ExceptionInInitializerError(e.getMessage()).initCause(e);
        }
    }

    private static final class ReferenceQueue
    extends java.lang.ref.ReferenceQueue<Object>
    implements Runnable {
        private static final ReferenceQueue INSTANCE = new ReferenceQueue();

        private ReferenceQueue() {
        }

        @Override
        public final void run() {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    ((DisposableReference)this.remove()).dispose();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        static {
            Thread t = new Thread((Runnable)INSTANCE, "DisposableReference disposer");
            t.setDaemon(true);
            t.setPriority(3);
            t.start();
        }
    }
}

