/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.bean;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import org.microbean.assign.AttributedType;
import org.microbean.assign.Matcher;
import org.microbean.assign.Selectable;
import org.microbean.bean.Bean;
import org.microbean.bean.Beans;
import org.microbean.bean.Id;
import org.microbean.bean.Ranked;

public final class Selectables {
    private Selectables() {
    }

    @Deprecated(forRemoval=true, since="0.0.19")
    public static final <C, E extends Ranked> Selectable<C, E> ambiguityReducing(Selectable<C, E> s) {
        return Selectables.ambiguityReducing(s, Ranked::alternate, Ranked::rank);
    }

    public static final <C, E> Selectable<C, E> ambiguityReducing(Selectable<C, E> s, Predicate<? super E> p, ToIntFunction<? super E> ranker) {
        Objects.requireNonNull(s, "s");
        Objects.requireNonNull(p, "p");
        Objects.requireNonNull(ranker, "ranker");
        return c -> {
            List elements = s.select(c);
            int size = elements.size();
            switch (size) {
                case 0: {
                    List.of();
                    break;
                }
                case 1: {
                    List.of(elements.get(0));
                    break;
                }
            }
            int maxRank = Integer.MIN_VALUE;
            ArrayList reductionList = new ArrayList(size);
            boolean reductionListContainsOnlyRankedAlternates = false;
            for (Object element : elements) {
                if (!p.test((Object)element)) continue;
                int rank = ranker.applyAsInt((Object)element);
                if (rank == 0) {
                    if (reductionListContainsOnlyRankedAlternates) {
                        reductionListContainsOnlyRankedAlternates = false;
                    }
                    reductionList.add(element);
                    continue;
                }
                if (reductionList.isEmpty()) {
                    assert (!reductionListContainsOnlyRankedAlternates) : "Unexpected reductionListContainsOnlyRankedAlternates: " + reductionListContainsOnlyRankedAlternates;
                    assert (rank > maxRank) : "rank <= maxRank: " + rank + " <= " + maxRank;
                    maxRank = rank;
                    reductionList.add(element);
                    reductionListContainsOnlyRankedAlternates = true;
                    continue;
                }
                if (reductionListContainsOnlyRankedAlternates) {
                    assert (reductionList.size() == 1) : "Unexpected reductionList size: " + String.valueOf(reductionList);
                    if (rank <= maxRank) continue;
                    maxRank = rank;
                    reductionList.set(0, element);
                    continue;
                }
                reductionList.add(element);
            }
            assert (!reductionListContainsOnlyRankedAlternates || reductionList.size() == 1) : "Unexpected reductionList size: " + String.valueOf(reductionList);
            if (reductionList.isEmpty()) {
                return elements;
            }
            if (reductionList.size() == 1) {
                return List.of(reductionList.get(0));
            }
            return List.copyOf(reductionList);
        };
    }

    public static final Selectable<AttributedType, Bean<?>> typesafeReducing(Collection<? extends Bean<?>> beans, Matcher<? super AttributedType, ? super Id> m) {
        Objects.requireNonNull(m, "m");
        List<Bean<?>> normalizedBeans = Beans.normalize(beans);
        return normalizedBeans.isEmpty() ? org.microbean.assign.Selectables.empty() : org.microbean.assign.Selectables.filtering(normalizedBeans, (b, c) -> m.test(c, (Object)b.id()));
    }
}

