/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.helidon.jerseysupport.cdi;

import io.helidon.webserver.jersey.JerseySupport;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.literal.InjectLiteral;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionTargetFactory;
import javax.enterprise.inject.spi.configurator.AnnotatedConstructorConfigurator;
import javax.enterprise.inject.spi.configurator.AnnotatedMethodConfigurator;
import javax.enterprise.inject.spi.configurator.AnnotatedParameterConfigurator;
import javax.ws.rs.core.Application;
import org.microbean.helidon.webserver.cdi.HelidonWebServerExtension;

public class JerseySupportExtension
implements Extension {
    private final <X extends Application> void createJerseySupportInstances(@Observes @Priority(value=1999) AfterBeanDiscovery event, BeanManager beanManager) {
        Set applicationBeans;
        if (event != null && beanManager != null && (applicationBeans = beanManager.getBeans(Application.class, new Annotation[]{Any.Literal.INSTANCE})) != null && !applicationBeans.isEmpty()) {
            HelidonWebServerExtension helidonWebServerExtension = (HelidonWebServerExtension)beanManager.getExtension(HelidonWebServerExtension.class);
            assert (helidonWebServerExtension != null);
            for (Bean applicationBean : applicationBeans) {
                if (applicationBean == null) continue;
                final Set qualifiers = applicationBean.getQualifiers();
                helidonWebServerExtension.addQualifiers(qualifiers);
                AnnotatedType jerseySupportAnnotatedType = beanManager.createAnnotatedType(JerseySupport.class);
                InjectionTargetFactory itf = beanManager.getInjectionTargetFactory(jerseySupportAnnotatedType);
                AnnotatedMethodConfigurator amc = ((AnnotatedMethodConfigurator)itf.configure().filterMethods(am -> am.getJavaMember().getName().equals("update")).findFirst().get()).add((Annotation)InjectLiteral.INSTANCE);
                AnnotatedParameterConfigurator rulesParameter = (AnnotatedParameterConfigurator)amc.filterParams(ap -> ap != null).findFirst().get();
                for (Annotation qualifier : qualifiers) {
                    rulesParameter.add(qualifier);
                }
                AnnotatedConstructorConfigurator ac = (AnnotatedConstructorConfigurator)itf.configure().filterConstructors(c -> c.getJavaMember().getParameterCount() == 2 && !c.getJavaMember().isSynthetic()).findFirst().get();
                ac.add((Annotation)InjectLiteral.INSTANCE);
                List apcs = ac.params();
                for (AnnotatedParameterConfigurator apc : apcs) {
                    for (Annotation qualifier : qualifiers) {
                        apc.add(qualifier);
                    }
                }
                BeanAttributes beanAttributes = beanManager.createBeanAttributes(jerseySupportAnnotatedType);
                DelegatingBeanAttributes<JerseySupport> jerseySupportBeanAttributes = new DelegatingBeanAttributes<JerseySupport>(beanAttributes){

                    @Override
                    public final Class<? extends Annotation> getScope() {
                        return ApplicationScoped.class;
                    }

                    @Override
                    public final Set<Annotation> getQualifiers() {
                        return qualifiers;
                    }
                };
                Bean jerseySupportBean = beanManager.createBean((BeanAttributes)jerseySupportBeanAttributes, jerseySupportAnnotatedType.getJavaClass(), itf);
                event.addBean(jerseySupportBean);
            }
        }
    }

    private static class DelegatingBeanAttributes<T>
    implements BeanAttributes<T> {
        private final BeanAttributes<T> delegate;

        private DelegatingBeanAttributes(BeanAttributes<T> delegate) {
            this.delegate = Objects.requireNonNull(delegate);
        }

        public Set<Type> getTypes() {
            return this.delegate.getTypes();
        }

        public Set<Annotation> getQualifiers() {
            return this.delegate.getQualifiers();
        }

        public Class<? extends Annotation> getScope() {
            return this.delegate.getScope();
        }

        public String getName() {
            return this.delegate.getName();
        }

        public Set<Class<? extends Annotation>> getStereotypes() {
            return this.delegate.getStereotypes();
        }

        public boolean isAlternative() {
            return this.delegate.isAlternative();
        }
    }
}

