/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.helm;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.HTTPGetAction;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretVolumeSource;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.extensions.Deployment;
import io.fabric8.kubernetes.api.model.extensions.DeploymentFluent;
import io.fabric8.kubernetes.api.model.extensions.DeploymentSpec;
import io.fabric8.kubernetes.api.model.extensions.DeploymentSpecFluent;
import io.fabric8.kubernetes.api.model.extensions.DoneableDeployment;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.ScalableResource;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.microbean.development.annotation.Experimental;

@Experimental
public class TillerInstaller {
    private static final Integer ONE = 1;
    private static final ImagePullPolicy DEFAULT_IMAGE_PULL_POLICY = ImagePullPolicy.IF_NOT_PRESENT;
    private static final String DEFAULT_NAME = "tiller";
    private static final String DEFAULT_NAMESPACE = "kube-system";
    private static final String TILLER_TLS_CERTS_PATH = "/etc/certs";
    public static final String VERSION = "2.7.0";
    private static final String DEFAULT_IMAGE_NAME = "gcr.io/kubernetes-helm/tiller:v2.7.0";
    private static final String DEFAULT_DEPLOYMENT_NAME = "tiller-deploy";
    private static final String SECRET_NAME = "tiller-secret";
    private final KubernetesClient kubernetesClient;
    private final String tillerNamespace;

    public TillerInstaller() {
        this((KubernetesClient)new DefaultKubernetesClient());
    }

    public TillerInstaller(KubernetesClient kubernetesClient) {
        Objects.requireNonNull(kubernetesClient);
        this.kubernetesClient = kubernetesClient;
        String tillerNamespace = System.getenv("TILLER_NAMESPACE");
        this.tillerNamespace = tillerNamespace == null || tillerNamespace.isEmpty() ? DEFAULT_NAMESPACE : tillerNamespace;
    }

    public void init() {
        try {
            this.init(false, null, null, null, null, null, null, null, false, false, false, null, null, null);
        }
        catch (IOException willNotHappen) {
            throw new AssertionError((Object)willNotHappen);
        }
    }

    public void init(boolean upgrade) {
        try {
            this.init(upgrade, null, null, null, null, null, null, null, false, false, false, null, null, null);
        }
        catch (IOException willNotHappen) {
            throw new AssertionError((Object)willNotHappen);
        }
    }

    public void init(boolean upgrade, String namespace, String deploymentName, String serviceName, Map<String, String> labels, String serviceAccountName, String imageName, ImagePullPolicy imagePullPolicy, boolean hostNetwork, boolean tls, boolean verifyTls, URI tlsKeyUri, URI tlsCertUri, URI tlsCaCertUri) throws IOException {
        block3: {
            namespace = this.normalizeNamespace(namespace);
            deploymentName = TillerInstaller.normalizeDeploymentName(deploymentName);
            serviceName = TillerInstaller.normalizeServiceName(serviceName);
            labels = TillerInstaller.normalizeLabels(labels);
            serviceAccountName = TillerInstaller.normalizeServiceAccountName(serviceAccountName);
            imageName = TillerInstaller.normalizeImageName(imageName);
            try {
                this.install(namespace, deploymentName, serviceName, labels, serviceAccountName, imageName, imagePullPolicy, hostNetwork, tls, verifyTls, tlsKeyUri, tlsCertUri, tlsCaCertUri);
            }
            catch (KubernetesClientException kubernetesClientException) {
                Status status = kubernetesClientException.getStatus();
                if (status == null || !"AlreadyExists".equals(status.getReason())) {
                    throw kubernetesClientException;
                }
                if (!upgrade) break block3;
                this.upgrade(namespace, deploymentName, serviceName, serviceAccountName, imageName, imagePullPolicy, labels);
            }
        }
    }

    public void install() {
        try {
            this.install(null, null, null, null, null, null, null, false, false, false, null, null, null);
        }
        catch (IOException willNotHappen) {
            throw new AssertionError((Object)willNotHappen);
        }
    }

    public void install(String namespace, String deploymentName, String serviceName, Map<String, String> labels, String serviceAccountName, String imageName, ImagePullPolicy imagePullPolicy, boolean hostNetwork, boolean tls, boolean verifyTls, URI tlsKeyUri, URI tlsCertUri, URI tlsCaCertUri) throws IOException {
        namespace = this.normalizeNamespace(namespace);
        labels = TillerInstaller.normalizeLabels(labels);
        Deployment deployment = this.createDeployment(namespace, TillerInstaller.normalizeDeploymentName(deploymentName), labels, TillerInstaller.normalizeServiceAccountName(serviceAccountName), TillerInstaller.normalizeImageName(imageName), imagePullPolicy, hostNetwork, tls, verifyTls);
        ((NonNamespaceOperation)this.kubernetesClient.extensions().deployments().inNamespace(namespace)).create((Object[])new Deployment[]{deployment});
        Service service = this.createService(namespace, TillerInstaller.normalizeServiceName(serviceName), labels);
        ((NonNamespaceOperation)this.kubernetesClient.services().inNamespace(namespace)).create((Object[])new Service[]{service});
        if (tls) {
            Secret secret = this.createSecret(namespace, tlsKeyUri, tlsCertUri, tlsCaCertUri, labels);
            ((NonNamespaceOperation)this.kubernetesClient.secrets().inNamespace(namespace)).create((Object[])new Secret[]{secret});
        }
    }

    public void upgrade() {
        this.upgrade(null, null, null, null, null, null, null);
    }

    public void upgrade(String namespace, String deploymentName, String serviceName, String serviceAccountName, String imageName, ImagePullPolicy imagePullPolicy, Map<String, String> labels) {
        namespace = this.normalizeNamespace(namespace);
        serviceName = TillerInstaller.normalizeServiceName(serviceName);
        ((DoneableDeployment)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((DoneableDeployment)((ScalableResource)((NonNamespaceOperation)this.kubernetesClient.extensions().deployments().inNamespace(namespace)).withName(TillerInstaller.normalizeDeploymentName(deploymentName))).edit()).editSpec().editTemplate().editSpec().editContainer(0).withImage(TillerInstaller.normalizeImageName(imageName))).withImagePullPolicy(TillerInstaller.normalizeImagePullPolicy(imagePullPolicy))).and()).withServiceAccountName(TillerInstaller.normalizeServiceAccountName(serviceAccountName))).endSpec()).endTemplate()).endSpec()).done();
        Service service = (Service)((Resource)((NonNamespaceOperation)this.kubernetesClient.services().inNamespace(namespace)).withName(serviceName)).get();
        if (service == null) {
            this.createService(namespace, serviceName, TillerInstaller.normalizeLabels(labels));
        }
    }

    protected Service createService(String namespace, String serviceName, Map<String, String> labels) {
        labels = TillerInstaller.normalizeLabels(labels);
        Service service = new Service();
        ObjectMeta metadata = new ObjectMeta();
        metadata.setNamespace(this.normalizeNamespace(namespace));
        metadata.setName(TillerInstaller.normalizeServiceName(serviceName));
        metadata.setLabels(labels);
        service.setMetadata(metadata);
        service.setSpec(this.createServiceSpec(labels));
        return service;
    }

    protected Deployment createDeployment(String namespace, String deploymentName, Map<String, String> labels, String serviceAccountName, String imageName, ImagePullPolicy imagePullPolicy, boolean hostNetwork, boolean tls, boolean verifyTls) {
        namespace = this.normalizeNamespace(namespace);
        labels = TillerInstaller.normalizeLabels(labels);
        Deployment deployment = new Deployment();
        ObjectMeta metadata = new ObjectMeta();
        metadata.setNamespace(namespace);
        metadata.setName(TillerInstaller.normalizeDeploymentName(deploymentName));
        metadata.setLabels(labels);
        deployment.setMetadata(metadata);
        deployment.setSpec(this.createDeploymentSpec(labels, serviceAccountName, imageName, imagePullPolicy, namespace, hostNetwork, tls, verifyTls));
        return deployment;
    }

    protected Secret createSecret(String namespace, URI tlsKeyUri, URI tlsCertUri, URI tlsCaCertUri, Map<String, String> labels) throws IOException {
        Secret secret = new Secret();
        secret.setType("Opaque");
        HashMap<String, String> secretData = new HashMap<String, String>();
        try (InputStream tlsKeyStream = TillerInstaller.read(tlsKeyUri);){
            if (tlsKeyStream != null) {
                secretData.put("tls.key", Base64.getEncoder().encodeToString(TillerInstaller.toByteArray(tlsKeyStream)));
            }
        }
        var9_9 = null;
        try (InputStream tlsCertStream = TillerInstaller.read(tlsCertUri);){
            if (tlsCertStream != null) {
                secretData.put("tls.crt", Base64.getEncoder().encodeToString(TillerInstaller.toByteArray(tlsCertStream)));
            }
        }
        catch (Throwable throwable) {
            var9_9 = throwable;
            throw throwable;
        }
        var9_9 = null;
        try (InputStream tlsCaCertStream = TillerInstaller.read(tlsCaCertUri);){
            if (tlsCaCertStream != null) {
                secretData.put("ca.crt", Base64.getEncoder().encodeToString(TillerInstaller.toByteArray(tlsCaCertStream)));
            }
        }
        catch (Throwable throwable) {
            var9_9 = throwable;
            throw throwable;
        }
        secret.setData(secretData);
        ObjectMeta metadata = new ObjectMeta();
        metadata.setNamespace(this.normalizeNamespace(namespace));
        metadata.setName(SECRET_NAME);
        metadata.setLabels(TillerInstaller.normalizeLabels(labels));
        secret.setMetadata(metadata);
        return secret;
    }

    protected DeploymentSpec createDeploymentSpec(Map<String, String> labels, String serviceAccountName, String imageName, ImagePullPolicy imagePullPolicy, String namespace, boolean hostNetwork, boolean tls, boolean verifyTls) {
        DeploymentSpec deploymentSpec = new DeploymentSpec();
        PodTemplateSpec podTemplateSpec = new PodTemplateSpec();
        ObjectMeta metadata = new ObjectMeta();
        metadata.setLabels(TillerInstaller.normalizeLabels(labels));
        podTemplateSpec.setMetadata(metadata);
        PodSpec podSpec = new PodSpec();
        podSpec.setServiceAccountName(TillerInstaller.normalizeServiceAccountName(serviceAccountName));
        podSpec.setContainers(Arrays.asList(this.createContainer(imageName, imagePullPolicy, namespace, tls, verifyTls)));
        podSpec.setHostNetwork(Boolean.valueOf(hostNetwork));
        HashMap<String, String> nodeSelector = new HashMap<String, String>();
        nodeSelector.put("beta.kubernetes.io/os", "linux");
        podSpec.setNodeSelector(nodeSelector);
        if (tls) {
            Volume volume = new Volume();
            volume.setName("tiller-certs");
            SecretVolumeSource secretVolumeSource = new SecretVolumeSource();
            secretVolumeSource.setSecretName(SECRET_NAME);
            volume.setSecret(secretVolumeSource);
            podSpec.setVolumes(Arrays.asList(volume));
        }
        podTemplateSpec.setSpec(podSpec);
        deploymentSpec.setTemplate(podTemplateSpec);
        return deploymentSpec;
    }

    protected Container createContainer(String imageName, ImagePullPolicy imagePullPolicy, String namespace, boolean tls, boolean verifyTls) {
        Container container = new Container();
        container.setName(DEFAULT_NAME);
        container.setImage(TillerInstaller.normalizeImageName(imageName));
        container.setImagePullPolicy(TillerInstaller.normalizeImagePullPolicy(imagePullPolicy));
        ContainerPort containerPort = new ContainerPort();
        containerPort.setContainerPort(Integer.valueOf(44134));
        containerPort.setName(DEFAULT_NAME);
        container.setPorts(Arrays.asList(containerPort));
        ArrayList<EnvVar> env = new ArrayList<EnvVar>();
        EnvVar tillerNamespace = new EnvVar();
        tillerNamespace.setName("TILLER_NAMESPACE");
        tillerNamespace.setValue(this.normalizeNamespace(namespace));
        env.add(tillerNamespace);
        if (tls) {
            EnvVar tlsVerify = new EnvVar();
            tlsVerify.setName("TILLER_TLS_VERIFY");
            tlsVerify.setValue(verifyTls ? "1" : "");
            env.add(tlsVerify);
            EnvVar tlsEnable = new EnvVar();
            tlsEnable.setName("TILLER_TLS_ENABLE");
            tlsEnable.setValue("1");
            env.add(tlsEnable);
            EnvVar tlsCerts = new EnvVar();
            tlsCerts.setName("TILLER_TLS_CERTS");
            tlsCerts.setValue(TILLER_TLS_CERTS_PATH);
            env.add(tlsCerts);
        }
        container.setEnv(env);
        IntOrString port44135 = new IntOrString(Integer.valueOf(44135));
        HTTPGetAction livenessHttpGetAction = new HTTPGetAction();
        livenessHttpGetAction.setPath("/liveness");
        livenessHttpGetAction.setPort(port44135);
        Probe livenessProbe = new Probe();
        livenessProbe.setHttpGet(livenessHttpGetAction);
        livenessProbe.setInitialDelaySeconds(ONE);
        livenessProbe.setTimeoutSeconds(ONE);
        container.setLivenessProbe(livenessProbe);
        HTTPGetAction readinessHttpGetAction = new HTTPGetAction();
        readinessHttpGetAction.setPath("/readiness");
        readinessHttpGetAction.setPort(port44135);
        Probe readinessProbe = new Probe();
        readinessProbe.setHttpGet(readinessHttpGetAction);
        readinessProbe.setInitialDelaySeconds(ONE);
        readinessProbe.setTimeoutSeconds(ONE);
        container.setReadinessProbe(readinessProbe);
        if (tls) {
            VolumeMount volumeMount = new VolumeMount();
            volumeMount.setName("tiller-certs");
            volumeMount.setReadOnly(Boolean.valueOf(true));
            volumeMount.setMountPath(TILLER_TLS_CERTS_PATH);
            container.setVolumeMounts(Arrays.asList(volumeMount));
        }
        return container;
    }

    protected ServiceSpec createServiceSpec(Map<String, String> labels) {
        ServiceSpec serviceSpec = new ServiceSpec();
        serviceSpec.setType("ClusterIP");
        ServicePort servicePort = new ServicePort();
        servicePort.setName(DEFAULT_NAME);
        servicePort.setPort(Integer.valueOf(44134));
        servicePort.setTargetPort(new IntOrString(DEFAULT_NAME));
        serviceSpec.setPorts(Arrays.asList(servicePort));
        serviceSpec.setSelector(TillerInstaller.normalizeLabels(labels));
        return serviceSpec;
    }

    protected final String normalizeNamespace(String namespace) {
        if ((namespace == null || namespace.isEmpty()) && ((namespace = this.tillerNamespace) == null || namespace.isEmpty())) {
            namespace = DEFAULT_NAMESPACE;
        }
        return namespace;
    }

    protected static final Map<String, String> normalizeLabels(Map<String, String> labels) {
        if (labels == null) {
            labels = new HashMap<String, String>(7);
        }
        if (!labels.containsKey("app")) {
            labels.put("app", "helm");
        }
        if (!labels.containsKey("name")) {
            labels.put("name", DEFAULT_NAME);
        }
        return labels;
    }

    protected static final String normalizeDeploymentName(String deploymentName) {
        if (deploymentName == null || deploymentName.isEmpty()) {
            return DEFAULT_DEPLOYMENT_NAME;
        }
        return deploymentName;
    }

    protected static final String normalizeImageName(String imageName) {
        if (imageName == null || imageName.isEmpty()) {
            return DEFAULT_IMAGE_NAME;
        }
        return imageName;
    }

    private static final String normalizeImagePullPolicy(ImagePullPolicy imagePullPolicy) {
        if (imagePullPolicy == null) {
            imagePullPolicy = DEFAULT_IMAGE_PULL_POLICY;
        }
        assert (imagePullPolicy != null);
        return imagePullPolicy.toString();
    }

    protected static final String normalizeServiceAccountName(String serviceAccountName) {
        return serviceAccountName == null ? "" : serviceAccountName;
    }

    protected static final String normalizeServiceName(String serviceName) {
        if (serviceName == null || serviceName.isEmpty()) {
            return DEFAULT_DEPLOYMENT_NAME;
        }
        return serviceName;
    }

    private static final InputStream read(URI uri) throws IOException {
        BufferedInputStream returnValue;
        if (uri == null) {
            returnValue = null;
        } else {
            URL url = uri.toURL();
            assert (url != null);
            InputStream uriStream = url.openStream();
            returnValue = uriStream == null ? null : (uriStream instanceof BufferedInputStream ? (BufferedInputStream)uriStream : new BufferedInputStream(uriStream));
        }
        return returnValue;
    }

    private static final byte[] toByteArray(InputStream inputStream) throws IOException {
        byte[] returnValue = null;
        if (inputStream != null) {
            int bytesRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            returnValue = new byte[4096];
            while ((bytesRead = inputStream.read(returnValue, 0, returnValue.length)) != -1) {
                buffer.write(returnValue, 0, bytesRead);
            }
            buffer.flush();
            returnValue = buffer.toByteArray();
        }
        return returnValue;
    }

    public static enum ImagePullPolicy {
        ALWAYS("Always"),
        IF_NOT_PRESENT("IfNotPresent"),
        NEVER("Never");

        private final String value;

        private ImagePullPolicy(String value) {
            Objects.requireNonNull(value);
            this.value = value;
        }

        public final String toString() {
            return this.value;
        }
    }
}

