/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.helm.chart;

import com.google.protobuf.AnyOrBuilder;
import com.google.protobuf.ByteString;
import hapi.chart.ChartOuterClass;
import hapi.chart.ConfigOuterClass;
import hapi.chart.MetadataOuterClass;
import hapi.chart.TemplateOuterClass;
import java.io.IOException;
import java.util.Objects;
import org.microbean.helm.chart.AbstractChartWriter;

public abstract class AbstractArchiveChartWriter
extends AbstractChartWriter {
    protected AbstractArchiveChartWriter() {
    }

    @Override
    protected void beginWrite(AbstractChartWriter.Context context, ChartOuterClass.ChartOrBuilder parent, ChartOuterClass.ChartOrBuilder chartBuilder) throws IOException {
        Objects.requireNonNull(context);
        Objects.requireNonNull(chartBuilder);
        if (parent == chartBuilder) {
            throw new IllegalArgumentException("parent == chartBuilder");
        }
        MetadataOuterClass.MetadataOrBuilder metadata = chartBuilder.getMetadataOrBuilder();
        if (metadata == null) {
            throw new IllegalArgumentException("chartBuilder", new IllegalStateException("chartBuilder.getMetadata() == null"));
        }
        String chartName = metadata.getName();
        if (chartName == null) {
            throw new IllegalArgumentException("chartBuilder", new IllegalStateException("chartBuilder.getMetadata().getName() == null"));
        }
        if (parent == null) {
            context.put("path", chartName + "/");
        } else {
            MetadataOuterClass.MetadataOrBuilder parentMetadata = parent.getMetadataOrBuilder();
            if (parentMetadata == null) {
                throw new IllegalArgumentException("parent", new IllegalStateException("parent.getMetadata() == null"));
            }
            String parentChartName = parentMetadata.getName();
            if (parentChartName == null) {
                throw new IllegalArgumentException("parent", new IllegalStateException("parent.getMetadata().getName() == null"));
            }
            context.put("path", context.get("path", String.class) + "charts/" + chartName + "/");
        }
    }

    @Override
    protected void writeMetadata(AbstractChartWriter.Context context, MetadataOuterClass.MetadataOrBuilder metadata) throws IOException {
        Objects.requireNonNull(context);
        Objects.requireNonNull(metadata);
        String yaml = this.toYAML(context, metadata);
        this.writeEntry(context, "Chart.yaml", yaml);
    }

    @Override
    protected void writeConfig(AbstractChartWriter.Context context, ConfigOuterClass.ConfigOrBuilder config) throws IOException {
        Objects.requireNonNull(context);
        if (config != null) {
            String raw = config.getRaw();
            String yaml = raw == null || raw.isEmpty() ? "" : this.toYAML(context, raw);
            this.writeEntry(context, "values.yaml", yaml);
        }
    }

    @Override
    protected void writeTemplate(AbstractChartWriter.Context context, TemplateOuterClass.TemplateOrBuilder template) throws IOException {
        ByteString data;
        String templateName;
        Objects.requireNonNull(context);
        if (template != null && (templateName = template.getName()) != null && !templateName.isEmpty() && (data = template.getData()) != null && data.size() > 0) {
            String dataString = data.toStringUtf8();
            assert (dataString != null);
            assert (!dataString.isEmpty());
            this.writeEntry(context, templateName, dataString);
        }
    }

    @Override
    protected void writeFile(AbstractChartWriter.Context context, AnyOrBuilder file) throws IOException {
        ByteString data;
        String fileName;
        Objects.requireNonNull(context);
        if (file != null && (fileName = file.getTypeUrl()) != null && !fileName.isEmpty() && (data = file.getValue()) != null && data.size() > 0) {
            String dataString = data.toStringUtf8();
            assert (dataString != null);
            assert (!dataString.isEmpty());
            this.writeEntry(context, fileName, dataString);
        }
    }

    @Override
    protected void endWrite(AbstractChartWriter.Context context, ChartOuterClass.ChartOrBuilder parent, ChartOuterClass.ChartOrBuilder chartBuilder) throws IOException {
        Objects.requireNonNull(context);
        Objects.requireNonNull(chartBuilder);
        if (chartBuilder == parent) {
            throw new IllegalArgumentException("chartBuilder == parent");
        }
        if (parent == null) {
            context.remove("path");
        } else {
            String path = context.get("path", String.class);
            assert (path != null);
            int chartsIndex = path.lastIndexOf("/charts/");
            assert (chartsIndex > 0);
            context.put("path", path.substring(0, chartsIndex + 1));
        }
    }

    protected abstract void writeEntry(AbstractChartWriter.Context var1, String var2, String var3) throws IOException;
}

