/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.helm.chart;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class HelmIgnorePathMatcher
implements PathMatcher,
Predicate<Path> {
    private final Collection<Predicate<Path>> rules = new ArrayList<Predicate<Path>>();

    public HelmIgnorePathMatcher() {
        this.addPattern("templates/.?*");
    }

    public HelmIgnorePathMatcher(Collection<? extends String> stringPatterns) {
        this();
        this.addPatterns(stringPatterns);
    }

    public HelmIgnorePathMatcher(Reader reader) throws IOException {
        this();
        if (reader != null) {
            BufferedReader bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
            assert (bufferedReader != null);
            this.addPatterns(bufferedReader.lines().collect(Collectors.toList()));
        }
    }

    public HelmIgnorePathMatcher(Path helmIgnoreFile) throws IOException {
        this(helmIgnoreFile == null ? (List<String>)null : Files.readAllLines(helmIgnoreFile, StandardCharsets.UTF_8));
    }

    public final void addPattern(String stringPattern) {
        this.addPatterns(stringPattern == null ? (Set<String>)null : Collections.singleton(stringPattern));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void addPatterns(Collection<? extends String> stringPatterns) {
        if (stringPatterns != null && !stringPatterns.isEmpty()) {
            for (String string : stringPatterns) {
                void var3_11;
                boolean basename;
                void var3_9;
                boolean requireDirectory;
                void var3_7;
                boolean negate;
                String string2;
                if (string == null || string.isEmpty() || (string2 = string.trim()).isEmpty() || string2.startsWith("#")) continue;
                if (string2.equals("!") || string2.equals("/")) {
                    throw new IllegalArgumentException("invalid pattern: " + string2);
                }
                if (string2.contains("**")) {
                    throw new IllegalArgumentException("invalid pattern: " + string2 + " (double-star (**) syntax is not supported)");
                }
                if (string2.startsWith("!")) {
                    assert (string2.length() > 1);
                    negate = true;
                    String string3 = string2.substring(1);
                } else {
                    negate = false;
                }
                if (var3_7.endsWith("/")) {
                    assert (var3_7.length() > 1);
                    requireDirectory = true;
                    String string4 = var3_7.substring(0, var3_7.length() - 1);
                } else {
                    requireDirectory = false;
                }
                int firstSlashIndex = var3_9.indexOf(47);
                if (firstSlashIndex < 0) {
                    basename = true;
                } else {
                    if (firstSlashIndex == 0) {
                        assert (var3_9.length() > 1);
                        String string5 = var3_9.substring(1);
                    }
                    basename = false;
                }
                StringBuilder regex = new StringBuilder("^");
                char[] chars = var3_11.toCharArray();
                assert (chars != null);
                assert (chars.length > 0);
                block9: for (char c : chars) {
                    switch (c) {
                        case '.': {
                            regex.append("\\.");
                            continue block9;
                        }
                        case '*': {
                            regex.append("[^").append(File.separator).append("]*");
                            continue block9;
                        }
                        case '?': {
                            regex.append("[^").append(File.separator).append("]?");
                            continue block9;
                        }
                        default: {
                            regex.append(c);
                        }
                    }
                }
                regex.append("$");
                RegexRule rule = new RegexRule(Pattern.compile(regex.toString()), requireDirectory, basename);
                Collection<Predicate<Path>> collection = this.rules;
                synchronized (collection) {
                    this.rules.add(negate ? rule.negate() : rule);
                }
            }
        }
    }

    @Override
    public final boolean test(Path path) {
        return this.matches(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean matches(Path path) {
        String pathString;
        boolean returnValue = false;
        if (path != null && !(pathString = path.toString()).equals(".") && !pathString.equals("./")) {
            Collection<Predicate<Path>> collection = this.rules;
            synchronized (collection) {
                for (Predicate<Path> rule : this.rules) {
                    if (rule == null || !rule.test(path)) continue;
                    returnValue = true;
                    break;
                }
            }
        }
        return returnValue;
    }

    private static final class RegexRule
    extends Rule {
        private final Pattern pattern;

        private RegexRule(Pattern pattern, boolean requireDirectory, boolean basename) {
            super(requireDirectory, basename);
            this.pattern = pattern;
        }

        @Override
        public final boolean test(Path path) {
            boolean returnValue = false;
            if ((path = this.normalizePath(path)) != null) {
                if (this.pattern == null) {
                    returnValue = true;
                } else {
                    Matcher matcher = this.pattern.matcher(path.toString());
                    assert (matcher != null);
                    returnValue = matcher.matches();
                }
            }
            return returnValue;
        }
    }

    private static abstract class Rule
    implements Predicate<Path> {
        private final boolean requireDirectory;
        private final boolean basename;

        protected Rule(boolean requireDirectory, boolean basename) {
            this.requireDirectory = requireDirectory;
            this.basename = basename;
        }

        protected final Path normalizePath(Path path) {
            Path returnValue = path;
            if (path != null) {
                if (this.basename) {
                    returnValue = path.getFileName();
                }
                if (this.requireDirectory && !Files.isDirectory(path, new LinkOption[0])) {
                    returnValue = null;
                }
            }
            return returnValue;
        }
    }
}

